
include(joinpath(@__DIR__, "run_ais.jl"))

nptls = 4096

for name in ["Brownian", "TReg", "SparseRegression" ,"LGCP"]
    for nrounds in [5]
        for seed in 1:10

        # run simulation
        df = run_sais(seed, name, nptls, nrounds; save_jld = true)

        # save simulation results
        res_dir = joinpath(@__DIR__, "csvs/")
        if !isdir(res_dir)
            mkpath(res_dir)
        end

        CSV.write(
            joinpath(res_dir, "sais_$(name)_$(nrounds)_$(seed).csv"),
            df,
        )

        end
    end
end

