# MixFlow.jl

Code for the NeurIPS 2025 submission ``Asymptotically exact variational ﬂows via involutive MCMC kernels''.
All methods and experiments are implemented in `Julia v1.11.5`.

- `src/` contains the code for the generic implementation of the 4 IRF flows based on 3 different involutive MCMC kernels---`HMC`, `MALA`, and `RWMH`.
- `example/` contains the code for all experiments in the paper.

To run the code, in the directory of this README file, run the following command in the terminal:
```
cd example/
julia --project=@julia_env 
```
This would open a julia REPL with the project environment `julia_env` activated.

Then, instantiate the julia environment, run the following command in the REPL:
```julia
] dev ../.      # load the implemented MixFlow.jl pkg
] instantiate   # install all the dependencies required by julia_env
```
This will install all the dependencies required to run the code.

Each directory in the `example/` folder contains a `run.jl` script. 
To run the experiment (e.g., getting all normalizing flow results for synthetic examples), cd into the corresponding directory (e.g., `synthetic_expt/normflow`) and execute `run.jl` in the REPL:
```julia
cd("synthetic_expt/normflow")
include("run.jl")
```
or just
```julia
# pwd() = "MixFlow.jl/example"
include("synthetic_expt/normflow/run.jl")
```

Note that before running any synthetic experiments, we need to first get the mean-field Gaussian reference:
```julia
include("synthetic_expt/reference/run.jl")
```

And for the real data experiments, we need to start with both the mean-field Gaussian reference, and the ground truth:
```julia
include("real-data_expt/reference/run.jl")
include("real-data_expt/ground_truth/run.jl")
```
