include(joinpath(@__DIR__, "run_mfvi.jl"))

csv_dir = joinpath(@__DIR__, "csvs/")

for name in ["Brownian", "TReg", "SparseRegression", "LGCP"]
    for lr in ["1e-3"]
        for niters in [50000]
            for bs in [32]
                for seed in 1:5
                    @info "Running MFVI baseline for $(name) with seed $(seed)"

                    # run simulation
                    df = run_baseline(
                        seed, name, lr;
                        batchsize=bs, niters=niters, show_progress=true,
                        nsample_eval=1024,
                        save_jld=true
                    )
                    CSV.write(
                        joinpath(csv_dir, "mfvi_$(name)_$(seed).csv"),
                        df,
                    )
                end
            end
        end
    end
end
