include(joinpath(@__DIR__, "run_nuts.jl"))


# Run NUTS and RWMH for all models
if !isdir(joinpath(@__DIR__, "results/"))
    mkpath(joinpath(@__DIR__, "results/"))
end

for name in ["Brownian", "TReg", "SparseRegression", "LGCP"]
    for seed in 1:10
        @info "Running NUTS for $(name) with seed $(seed)"
        df = df_nuts(seed, name; n_samples=5000)
        CSV.write(
            joinpath(@__DIR__, "results/nuts_$(name)_$(seed).csv"),
            df,
            writeheader=true,
            append=false,
        )
    end
end


for name in ["Brownian", "TReg", "SparseRegression", "LGCP"]
    for flowtype in [BackwardIRFMixFlow, DeterministicMixFlow, EnsembleIRFFlow, IRFMixFlow]
        for seed in 1:32
            @info "Running RWMH importance sampling results for $(name) of $(flowtype) with seed $(seed)"
            df = df_rwmh_is(seed, name, flowtype)
            CSV.write(
                joinpath(@__DIR__, "results/rwmh_$(name)_$(flowtype)_$(seed).csv"),
                df,
                writeheader=true,
                append=false,
            )
        end
    end
end