include("irf_rwmh.jl")


nrep = 32
nsample = 64
nchains = 30

for name in ["LGCP", "Brownian", "SparseRegression", "TReg"]
    for flowtype in [MF.DeterministicMixFlow, MF.BackwardIRFMixFlow, MF.EnsembleIRFFlow, MF.IRFMixFlow]
        for kernel in [RWMH]
            for T in [5000]
                for seed in 1:nrep
                    println("Running simulation with seed: $seed, name: $name, flowtype: $flowtype, kernel: $kernel, T: $T")
                    
                    # skip IRFMixFlow for LGCP
                    if name == "LGCP" && flowtype == MF.IRFMixFlow
                        continue
                    end

                    # for IRFMixFlow, set flowlength to 4000
                    if flowtype == MF.IRFMixFlow
                        T = 4000
                    end

                    df, _ = run_simulation(seed, name, flowtype, kernel, T, nchains; nsample = nsample, save_jld = true, track_cost = true)  
                    
                    # make a dir named LGCP_csv/
                    # save csv in LGCP_csv/
                    if !isdir("$name/")
                        mkpath("$name/")
                    end
                    # save df in the dir in csv
                    CSV.write(joinpath("$name/", "rwmh_$(name)_$(flowtype)_$seed.csv"), df)
                end
            end
        end
    end
end
