include(joinpath(@__DIR__, "normflow.jl"))

for name in ["Banana", "Funnel", "WarpedGaussian", "Cross"]
    for flowtype in ["real_nvp", "neural_spline_flow"]
        for nlayer in [3, 5]
            for niters in [100000]
                for bs in [32]
                    for lr in [1e-2, 1e-3, 1e-4]
                        for seed in 1:10

                            # run simulation
                            # run simulation
                            df = run_norm_flow(
                                seed, name, flowtype, lr;
                                batchsize=bs, niters=niters, show_progress=true,
                                nsample_eval=1024,
                            )

                            res_dir = joinpath(@__DIR__, "csvs/")
                            if !isdir(res_dir)
                                mkpath(res_dir)
                            end

                            CSV.write(
                                joinpath(res_dir, "normflow_$(name)_$(flowtype)_$(nlayer)_$(lr)_$(seed).csv"),
                                df,
                            )
                        end
                    end
                end
            end
        end
    end
end
