import json
import re
import pandas as pd

#with open('../results/predictions_gpt-3.5-turbo-1106_type4_prompt-2_first-60.json', 'r') as f:
with open('../results/predictions_gpt-3.5-turbo-1106.json', 'r') as f:
    predictions = json.load(f)

workers_id = [p['worker_id'] for p in predictions]

survey = pd.read_csv('../data/survey_responses.csv')
survey = survey[survey['worker_id'].isin(workers_id)]
survey = survey.drop(columns=['session_id', 'prompt', 'change_freetext', 'adjectives'])
survey = survey.set_index('worker_id')
survey = survey.to_dict('index')

def parse_line(line):
    if ':' in line:
        number = int(line.split(':')[-1].strip())
    else:
        number = int(line.strip()[-2])
    return number

for pred in predictions:
    pred_text = pred['prediction']
    pred_text = re.sub('\n\n', '\n', pred_text)
    pred_text = pred_text.split('\n')
    fluency, helpful, ease = pred_text[:3]
    helpful_text = '\n'.join(pred_text[3:])
    print(fluency)
    print(helpful)
    print(ease)
    print(helpful_text)
    try:
        fluency = parse_line(fluency)
        helpful = parse_line(helpful)
        ease = parse_line(ease)
    except Exception as e:
        print(pred_text)
        input()
    if 'helpfulness:' == helpful_text.lower()[:12]:
        helpful_text = helpful_text[12:].strip()
    elif 'helpfulness (free-form): ' == helpful_text.lower()[:25]:
        helpful_text = helpful_text[25:].strip()
    survey[pred['worker_id']]['fluency'] = fluency
    survey[pred['worker_id']]['helpfulness'] = helpful
    survey[pred['worker_id']]['ease'] = ease
    survey[pred['worker_id']]['helpfulness_text'] = helpful_text

df = pd.DataFrame.from_dict(survey, orient='index').reset_index()
df = df.rename(columns={'index': 'worker_id'})

#df.to_csv('../results/predictions_gpt-3.5-turbo-1106_type4_prompt-2_first-60.csv', index=False)
df.to_csv('../results/predictions_gpt-3.5-turbo-1106.csv', index=False)

