# Twinned Interventional Flows: POMDPs with continuous dynamics provably benefit from observational data


## Requirements
Code can be run in conda python (3.) enviroment by installing requirements from the ```environment-cpu.yml``` or ```environment.yml``` file.
In addition one needs an active Wandb entity.

To generate data for PK-PD model run:
```setup
python generate_dat.py --coeff <coeff> --kappa <kappa> --save_raw_datapath tumorData/raw --save_transformed_datapath tumorData/transformed
```
Or If you wish greata a new version of transformed data with different value of kappa, run:
```setup
python generate_dat.py --coeff <coeff> --kappa <kappa> --data_path tumorData/raw --save_transformed_datapath tumorData/transformed
```
The pendulum data is regenerated during each model training/testing

## Training and Testing

To train the and test TIF in pendulum data run:

```train
python train_model.py --entity <wnadb user name> --seed=<seed> --max_epochs 100 --N_int 50 --N_obs 600 --batch_size 258 --num_blocks 1 --lr 0.005 --loss_func mse --observational 2 --state_dim 20 --reg1 0.4
```
OBS. regularization is relaxed, but it can esily be returned in buildmodel.py file, and uncommenting the loglikelihood calculations in validation step.

And to train and test TIF with the tumor growth data, run for example:
```train
python train_model.py --dataset_name tumor --entity <wnadb user name> --seed=<seed> --max_epochs 100 --batch_size 516 --num_blocks 1 --lr 0.001 --loss_func mse --state_dim 20 --coeff <coeff> --kappa <kappa> --data_path tumorData/transformed
```

### Parameters for the model training
```max_epochs```: Maximum number of epochs in training

```gpu```: Number of gpus available, if any

```dataset_name```: "pendulum" or "tumor"

```entity```: Wandb username

```run_note```: Used to name the run in Wandb

```state_dim```: Dimension of state i.e. $|l| + |o|$

```num_blocks```: Number of concatsquach blocks

```lr```: Maximum learning rate for Adam

```gpu```: Number of gpus available, if any

```reg1```: scaling of our regularization, default 0

```reg2```: scaling of Jacobian and kinetik regularization, set to 0

```seed```: random seed

```batch_size```: batch size, if batch size given is bigger than the number of data trajectories N, N is used istead

#### Pendulum parameters
```observational```: training approach so that 0: only observational data, 1: only interventional data, 2: combined

```N_int```: Number of interventional samples in training, if any

```N_obs```: Number of observational samples in training, if any

```obs_length```: Number of observed timesteps, default 30

#### Tumor parameters
```data_path```: Number of interventional samples in training, if any

```coeff```: $gamma$ used in data generation

```kappa```: $kappa$ value used in Hawkes process

OBS! corresponding file has to be found in the data_path folder that is located just outside of this folder.








