import pandas as pd
import numpy as np
import random
#from torchsummary import summary
import plotly.express as px
import plotly.graph_objects as go
from plotly.subplots import make_subplots
import torch

def hex_to_rgba(h, alpha):
    '''
    converts color value in hex format to rgba format with alpha transparency
    '''
    return tuple([int(h.lstrip('#')[i:i+2], 16) for i in (0, 2, 4)] + [alpha])


def plot_trajectories(X, Y_hat, t, dataset_name, chart_type = "val", logger=None ):
    #color = cm.rainbow(np.linspace(0, 1, n))
    if X.shape[-1] > 5:
        X = X[:,:,-5:]
        Y_hat = Y_hat[:,:,-5:]
        plot_n = 5
    else:
        plot_n = X.shape[-1]
        

    X_df_list = []
    time = t[0,:].cpu().numpy() #np.arange(X.shape[1])
    for dim in range(plot_n):
        X_df = pd.DataFrame(X.cpu().numpy()[0,:,dim], columns = [dataset_name])
        X_df["time"]  = time
        X_df["dim"] = dim
        X_df["type"] = "Input"
        X_df["std"] = 0
        X_df_list.append(X_df)
    X_df = pd.concat(X_df_list)
    time_x_end = X_df.time.max() + 1

    if (Y_hat.dim()<3): #dimension for obs_dim
        Y_hat = Y_hat.unsqueeze(-1)

    #for sample in range(Y_hat.shape[0]):
    Y_df_list=[]
    for dim in range(plot_n):
        std_hat = 0
        Y_hat_fact_df = pd.DataFrame(Y_hat.cpu().numpy()[0,:,dim], columns = [dataset_name])
        Y_hat_fact_df["time"]  = time#[1:]
        Y_hat_fact_df["dim"] = dim
        Y_hat_fact_df["type"] = "Prediction"
        Y_hat_fact_df["std"] = std_hat
        Y_df_list.append(Y_hat_fact_df)

    Y_hat_fact_df = pd.concat(Y_df_list)
    df = pd.concat([Y_hat_fact_df, X_df])
    fig = px.line(df, x = "time",y = dataset_name, color="dim", line_dash="type" , error_y ="std", title = f"{chart_type} longitudinal predictions - dimension {dim}") 
    #fig = px.line(X_df, x = "time",y = dataset_name,color="dim", error_y ="std", title = f"{chart_type} longitudinal predictions - dimension {dim}") 
    #fig.add_trace()
    #fig.show()
    if type(logger).__name__ == "WandbLogger":
        logger.experiment.log({f"{chart_type} chart {dim}":fig},step = logger.experiment.step)
    else:
        print("Missing graph")

def plot_trajectories_test(X, Y_hat, t, a, dataset_name, chart_type = "test", logger=None ):
    """
    y_hats: samples x time x dim
    """
    if X.shape[-1] > 5:
        X = X[:,:,-5:]
        Y_hat = Y_hat[:,:,-5:]
        plot_n = 5
    else:
        plot_n = X.shape[-1]

    X_df_list = []
    Y_df_list=[]
    #df = pd.DataFrame()
    time = t[0,:].cpu().numpy() #np.arange(X.shape[1])
    if dataset_name == "eeg":
        a = a[:,:,0][...,None] #onehot to 0/1 
    for dim in range(plot_n):#[::5]:
        X_df = pd.DataFrame(X.cpu().numpy()[0,:,dim], columns = [dataset_name])
        X_df["time"]  = time
        X_df["type"] = f"Input_{dim}"
        X_df["dim"] = dim
        X_df_list.append(X_df)

        time_x_end = X_df.time.max() + 1

        if (Y_hat.dim()<3): #dimension for obs_dim
            Y_hat = Y_hat.unsqueeze(-1)
        
        #for sample in range(Y_hat.shape[0]):
        #for dim in range(Y_hat.shape[-1]):
        std_hat = 0
        Y_hat_fact_df = pd.DataFrame(Y_hat.cpu().numpy()[:,:,dim].mean(axis=0), columns = [dataset_name])
        Y_hat_fact_df["time"]  = time#[1:]
        Y_hat_fact_df["type"] = "Factual Prediction Mean"
        Y_hat_fact_df["dim"] = dim
        Y_hat_fact_df["std"] = std_hat#Y_hat.cpu().numpy()[:,:,dim].std(axis=0)
        Y_df_list.append(Y_hat_fact_df)

    X_df = pd.concat(X_df_list)
    Y_df = pd.concat(Y_df_list)
    df = pd.concat([X_df, Y_df])

    fig = px.line(df, x = "time",y = dataset_name,color="dim", line_dash="type", error_y ="std", title = f"{chart_type} longitudinal predictions - dimension {dim}")
    #fig.data[0].mode = 'lines+markers'
    #fig.data[1].mode = 'lines+markers'
    z_studentT = 0.924
    sqrtn = np.sqrt(X.size()[0])
    ystd = Y_hat.cpu().numpy()[:,:,dim].std(axis=0)
    ymean = Y_hat.cpu().numpy()[:,:,dim].mean(axis=0)
    Y_upper = ymean + ystd #z_studentT*ystd/sqrtn
    Y_lower = ymean - ystd #z_studentT*ystd/sqrtn
    
    fig.add_trace(go.Scatter(
        x=list(time)+list(time[::-1]),
        y=list(Y_upper)+list(Y_lower[::-1]),
        fill='toself',
        fillcolor='rgba(233, 116, 81,0.2)',
        line_color='rgba(255,255,255,0)',
        showlegend=False,
        name='Fair',
        mode='lines',
    ))

    amax= np.max(a[0,:,0].cpu().numpy())
    amin= np.min(a[0,:,0].cpu().numpy())
    fig.add_trace(go.Scatter(
        x = time,
        y = np.repeat(np.min([np.min(Y_lower),np.min(X.cpu().numpy())])-0.2, t.shape[0]),
        marker=dict(
            size=10,
            #cmax=amax,#max(a[0,:,0]).item(),
            #cmin=amin,#min(a[0,:,0]).item(),
            color=a[0,:,0].cpu().numpy(),
            colorbar=dict(
                title="Action amplitude"
            ),
            colorscale="Sunset",
            showscale=True
        ),
        #marker_color = a[0,:].numpy()[:,0],
        mode="markers",
        name='Action'
    ))
    fig.update_layout(legend_orientation="h")
    #fig.show()

    if type(logger).__name__ == "WandbLogger":
        logger.experiment.log({f"{chart_type} chart {dim}":fig},step = logger.experiment.step)
    else:
        print("Missing graph")


def plot_several_predictions(X, Y_hat,time,colors, fig, dim, col=None, row=None):
    fig.add_trace(go.Scatter(
        x = time,
        y = X, 
        line_color='rgba' + str(hex_to_rgba(h=colors[dim], alpha=1.0 )), 
        name='dim '+str(dim)
        ),
        row=row, col=col
        )

    for i in range(Y_hat.shape[0]-1):
        fig.add_trace(go.Scatter(
        x=list(time),
        y=Y_hat[i,:],
        line_color='rgba' + str(hex_to_rgba(h=colors[dim], alpha=0.2 )), #'rgba(233, 116, 81,0.2)',
        showlegend=False,
        name='Fair',
        ),
        row=row, col=col
        )
    i= Y_hat.shape[0]-1
    fig.add_trace(go.Scatter(
        x=list(time),
        y=Y_hat[i,:],
        line_color='rgba' + str(hex_to_rgba(h=colors[dim], alpha=0.2 )), #'rgba(233, 116, 81,0.2)',
        name='Prediction for dim'+ str(dim),
        ),
        row=row, col=col
        )

def plot_trajectories_test_all(X, Y_hat, t, dataset_name, chart_type = "test2", logger= None ):
    """
    y_hats: samples x time x dim
    """
    if X.shape[-1] > 5:
        X = X[:,:,-5:]
        Y_hat = Y_hat[:,:,-5:]
        plot_n = 5
    else:
        plot_n = X.shape[-1]

    colors = px.colors.qualitative.G10
    N = Y_hat.size()[0]
    #X_df_list = []
    #Y_df_list =[]
    time = t[0,:].cpu().numpy() #np.arange(X.shape[1])

    fig = go.Figure()
    fig.update_layout(title_text=f"{chart_type} longitudinal predictions")

    for dim in range(plot_n):#[::5]:
        if (Y_hat.dim()<3): #dimension for obs_dim
            Y_hat = Y_hat.unsqueeze(-1)

        plot_several_predictions(X.cpu().numpy()[0,:,dim], Y_hat.cpu().numpy()[:,:,dim],time, colors, fig, dim)
        #X_df_list = []
        #X_df = pd.DataFrame(X.cpu().numpy()[0,:,dim], columns = [dataset_name])
        #X_df["time"]  = time
        #X_df["type"] = f"Input_{dim}"
        #X_df_list.append(X_df)
        # << 
        #X_df = pd.concat(X_df_list)

        
        """
        columns= np.array([dataset_name]).repeat(N)
        #for sample in range(Y_hat.shape[0]):
        #df=X_df

        #'rgba' + str(hex_to_rgba(h=colors[i], alpha=0.0 ))

        fig.add_trace(go.Scatter(
            x = time,
            y = X.cpu().numpy()[0,:,dim], 
            line_color='rgba' + str(hex_to_rgba(h=colors[dim], alpha=1.0 )), 
            name='dim '+str(dim)
            ))

        for i in range(Y_hat.shape[0]-1):
            fig.add_trace(go.Scatter(
            x=list(time),
            y=Y_hat.cpu().numpy()[i,:,dim],
            line_color='rgba' + str(hex_to_rgba(h=colors[dim], alpha=0.2 )), #'rgba(233, 116, 81,0.2)',
            showlegend=False,
            name='Fair',
            ))
        i= Y_hat.shape[0]-1
        fig.add_trace(go.Scatter(
            x=list(time),
            y=Y_hat.cpu().numpy()[i,:,dim],
            line_color='rgba' + str(hex_to_rgba(h=colors[dim], alpha=0.2 )), #'rgba(233, 116, 81,0.2)',
            name='Prediction for dim'+ str(dim),
            ))
        """
    #fig.show()
    if type(logger).__name__ == "WandbLogger":
        logger.experiment.log({f"{chart_type} chart {dim}":fig},step = logger.experiment.step)
    else:
        print("Missing graph")

def plot_trajectories_with_logprobabilities(X, X_corrupt, Y_hat, t, logProb, Prob_0, dataset_name, chart_type = "loglikelihoods", logger= None, row=None, col=None):
    """
    X: ground truth samples x time x dim
    y_hat: predictions samples x time x dim
    t: samples x time
    logProb: samples x time x dim
    """
    #if X.shape[-1] > 5:
    #    X = X[:,:,-5:]
    ##    Y_hat = Y_hat[:,:,-5:]
    #    plot_n = 5
    #else:
    #    plot_n = X.shape[-1]

    colors = px.colors.qualitative.G10
    N = Y_hat.size()[0]
    t_n = Y_hat.size()[1]
    t_dim = X.shape[1] #-1??
    X_df_list = []
    Y_df_list = []
    time = t[0,:].cpu().numpy() #np.arange(X.shape[1])
    max_t = np.max(time)
    fig = make_subplots(rows=2, cols=1)

    for dim in range(X.shape[-1])[:5]:
        #if (Y_hat.dim()<3): #dimension for obs_dim
        #    Y_hat = Y_hat.unsqueeze(-1)

        #plot_several_predictions(X.cpu().numpy()[0,:,dim], Y_hat.cpu().numpy()[:,:,dim],time,colors, fig, dim, col=1, row=1)
        fig.add_trace(go.Scatter(
            x = time,
            y = X.cpu().numpy()[0,:,dim], 
            line_color='rgba' + str(hex_to_rgba(h=colors[dim], alpha=1.0 )), 
            name='dim '+str(dim)
            ),
            row=1, col=1
            )
        fig.add_trace(go.Scatter(
            x = time,
            y = X_corrupt.cpu().numpy()[0,:,dim], 
            line_color='rgba' + str(hex_to_rgba(h=colors[dim], alpha=0.7 )), 
            name='dim_corrupt '+str(dim),
            ),
            row=1, col=1
            )
        fig.add_trace(go.Scatter(
            x=time,
            y=torch.mean(Y_hat[:,:,dim],dim=0).cpu().numpy(),
            line_color='rgba' + str(hex_to_rgba(h=colors[dim], alpha=0.5 )), #'rgba(233, 116, 81,0.2)',
            name='Prediction for dim'+ str(dim),
            ),
            row=row, col=col
            )
        y_upper = torch.mean(Y_hat[:,:,dim], dim=0).cpu().numpy() + torch.std(Y_hat[:,:,dim], dim=0).cpu().numpy()
        y_lower = torch.mean(Y_hat[:,:,dim], dim=0).cpu().numpy() - torch.std(Y_hat[:,:,dim], dim=0).cpu().numpy()

        fig.add_trace(go.Scatter(
            x=list(time)+list(time[::-1]), # x, then x reversed
            y=list(y_upper)+list(y_lower[::-1]), # upper, then lower reversed
            fill='toself',
            line= dict(color='rgba' + str(hex_to_rgba(h=colors[dim], alpha=0.2 ))),
            hoverinfo="skip",
            showlegend=False
        ))

    fig.add_trace(go.Bar(
        x=time,# + dim*(max_t/t_n)/(t_dim*2),
        y=torch.mean(logProb[:,:,0]+ logProb[:,:,1], dim=0).cpu().numpy() + torch.log(torch.mean(Prob_0[:,:,0]*Prob_0[:,:,1], dim=0)).cpu().numpy(),# + torch.log(torch.mean(Prob_0[:,:,1], dim=0)).cpu().numpy(),
        name='-log likelihood dim' + str(dim),
        marker_color='rgba' + str(hex_to_rgba(h=colors[0], alpha=1.0 )),
        error_y = dict(type='data', array=torch.std(logProb, dim=0).cpu().numpy()),
        width = (max_t/t_n)/2
        ),
        row=2,col=1)

    fig.show()
    if type(logger).__name__ == "WandbLogger":
        logger.experiment.log({f"{chart_type} chart {dim}":fig},step = logger.experiment.step)
    else:
        print("Missing graph")

def line(error_y_mode=None, **kwargs):
    """Extension of `plotly.express.line` to use error bands."""
    ERROR_MODES = {'bar','band','bars','bands',None}
    if error_y_mode not in ERROR_MODES:
        raise ValueError(f"'error_y_mode' must be one of {ERROR_MODES}, received {repr(error_y_mode)}.")
    if error_y_mode in {'bar','bars',None}:
        fig = px.line(**kwargs)
    elif error_y_mode in {'band','bands'}:
        if 'error_y' not in kwargs:
            raise ValueError(f"If you provide argument 'error_y_mode' you must also provide 'error_y'.")
        figure_with_error_bars = px.line(**kwargs)
        fig = px.line(**{arg: val for arg,val in kwargs.items() if arg != 'error_y'})
        for data in figure_with_error_bars.data:
            x = list(data['x'])
            y_upper = list(data['y'] + data['error_y']['array'])
            y_lower = list(data['y'] - data['error_y']['array'] if data['error_y']['arrayminus'] is None else data['y'] - data['error_y']['arrayminus'])
            color = f"rgba({tuple(int(data['line']['color'].lstrip('#')[i:i+2], 16) for i in (0, 2, 4))},.3)".replace('((','(').replace('),',',').replace(' ','')
            fig.add_trace(
                go.Scatter(
                    x = x+x[::-1],
                    y = y_upper+y_lower[::-1],
                    fill = 'toself',
                    fillcolor = color,
                    line_color='rgba(255,255,255,0)',
                    # = dict(
                    #    color = 'rgba(255,255,255,0)'
                    #),
                    hoverinfo = "skip",
                    showlegend = False,
                    legendgroup = data['legendgroup'],
                    xaxis = data['xaxis'],
                    yaxis = data['yaxis'],
                )
            )
        # Reorder data as said here: https://stackoverflow.com/a/66854398/8849755
        reordered_data = []
        for i in range(int(len(fig.data)/2)):
            reordered_data.append(fig.data[i+int(len(fig.data)/2)])
            reordered_data.append(fig.data[i])
        fig.data = tuple(reordered_data)
    return fig



def plot_forward_backcward(X, Y_hat, Y_hat_back, t, a, dataset_name, chart_type = "test", logger=None ):
    """
    y_hats: samples x time x dim
    """
    if X.shape[-1] > 5:
        X = X[:,:,-5:]
        Y_hat = Y_hat[:,:,-5:]
        plot_n = 5
    else:
        plot_n = X.shape[-1]

    X_df_list = []
    Y_df_list=[]
    Y_back_list=[]
    time = t[0,:].cpu().numpy() #np.arange(X.shape[1])
    figs = []
    df = pd.DataFrame()
    if dataset_name == "eeg":
        a = a[:,:,0][...,None] #onehot to 0/1 
    for dim in range(plot_n):#[::5]:
        X_df = pd.DataFrame(X.cpu().numpy()[0,:,dim], columns = [dataset_name])
        X_df = X_df.where(pd.notnull(X_df), np.NaN)
        X_df["time"]  = time
        X_df["type"] = f"Input_{dim}"
        X_df["dim"] = dim
        X_df["std"] = 0
        X_df_list.append(X_df)

        time_x_end = X_df.time.max() + 1

        if (Y_hat.dim()<3): #dimension for obs_dim
            Y_hat = Y_hat.unsqueeze(-1)
        
        #for sample in range(Y_hat.shape[0]):
        #for dim in range(Y_hat.shape[-1]):
        std_hat = Y_hat.cpu().numpy()[:,:,dim].std(axis=0)
        Y_hat_fact_df = pd.DataFrame(Y_hat.cpu().numpy()[:,:,dim].mean(axis=0), columns = [dataset_name])
        Y_hat_fact_df = Y_hat_fact_df.where(pd.notnull(Y_hat_fact_df), np.NaN)
        Y_hat_fact_df["time"]  = time#[1:]
        Y_hat_fact_df["type"] = "Forward Prediction Mean"
        Y_hat_fact_df["dim"] = dim
        Y_hat_fact_df["std"] = std_hat#Y_hat.cpu().numpy()[:,:,dim].std(axis=0)

        std_hat = Y_hat_back.cpu().numpy()[:,:,dim].std(axis=0)
        Y_hat_back_df = pd.DataFrame(Y_hat_back.cpu().numpy()[:,:,dim].mean(axis=0), columns = [dataset_name])
        Y_hat_back_df = Y_hat_back_df.where(pd.notnull(Y_hat_back_df), np.NaN)
        Y_hat_back_df["time"]  = time#[1:]
        Y_hat_back_df["type"] = "Backward Prediction Mean"
        Y_hat_back_df["dim"] = dim
        Y_hat_back_df["std"] = std_hat #Y_hat.cpu().numpy()[:,:,dim].std(axis=0)

        Y_df_list.append(Y_hat_fact_df)
        Y_back_list.append(Y_hat_back_df)
    X_df = pd.concat(X_df_list)
    Y_df = pd.concat(Y_df_list)
    Y_df_back = pd.concat(Y_back_list) 
    df = pd.concat([X_df, Y_df, Y_df_back])
    df = df.where(pd.notnull(df), np.NaN) #replace(np.nan, None)
    #df = pd.concat([df, Y_hat_fact_df])
    #df = pd.concat([df, X_df])
    #df = pd.concat([df, Y_hat_back_df])
    fig = line(
        data_frame= df, 
        x = "time",
        y = dataset_name,
        color="dim", 
        line_dash="type", 
        error_y ="std",
        error_y_mode ='band', 
        title = f"{chart_type} longitudinal predictions - dimension {dim}",
        )
    #fig.data[0].mode = 'lines+markers'
    #fig.data[1].mode = 'lines+markers'
    
    z_studentT = 0.924
    sqrtn = np.sqrt(X.size()[0])
    ystd = Y_hat.cpu().numpy()[:,:,dim].std(axis=0)
    ymean = Y_hat.cpu().numpy()[:,:,dim].mean(axis=0)
    Y_upper = ymean + ystd #z_studentT*ystd/sqrtn
    Y_lower = ymean - ystd #z_studentT*ystd/sqrtn
    '''
    
    fig.add_trace(go.Scatter(
        x=list(time)+list(time[::-1]),
        y=list(Y_upper)+list(Y_lower[::-1]),
        fill='toself',
        fillcolor='rgba(233, 116, 81,0.2)',
        line_color='rgba(255,255,255,0)',
        showlegend=False,
        name='Fair',
        mode='lines',
    ))
    '''

    amax= np.max(a[0,:,0].cpu().numpy())
    amin= np.min(a[0,:,0].cpu().numpy())
    fig.add_trace(go.Scatter(
        x = time,
        y = np.repeat(np.min([np.min(Y_lower),np.min(X.cpu().numpy())])-0.2, t.shape[0]),
        marker=dict(
            size=10,
            #cmax=amax,#max(a[0,:,0]).item(),
            #cmin=amin,#min(a[0,:,0]).item(),
            color=a[0,:,0].cpu().numpy(),
            colorbar=dict(
                title="Action amplitude"
            ),
            colorscale="Sunset",
            showscale=True
        ),
        #marker_color = a[0,:].numpy()[:,0],
        mode="markers",
        name='Action'
    ))
    #figs.append(fig)
    #fig = go.Figure(data = figs[0].data + figs[1].data)
    #fig.update_layout(legend_orientation="h")

    #fig.show()

    if type(logger).__name__ == "WandbLogger":
        logger.experiment.log({f"{chart_type} chart {dim}":fig},step = logger.experiment.step)
    else:
        print("Missing graph")

        

def plot_trajectories_test_simple(X, X_mask, Y_hat, t, a, dataset_name, chart_type = "test", logger=None ):
    """
    y_hats: samples x time x dim
    """
    if X.shape[-1] > 5:
        X = X[:,:,-5:]
        Y_hat = Y_hat[:,:,-5:]
        plot_n = 5
    else:
        plot_n = X.shape[-1]

    X_df_list = []
    X_masked_df_list = []
    Y_df_list = []
    time = t[0,:].cpu().numpy() #np.arange(X.shape[1])
    df=pd.DataFrame()
    for dim in range(plot_n):#[::5]:
        X_df = pd.DataFrame(X.cpu().numpy()[0,:,dim], columns = [dataset_name])
        X_df["time"]  = time
        X_df["type"] = f"Input_{dim}"
        X_df["dim"] = dim
        #X_df["std"] = 0
        X_df_list.append(X_df)

        X_mask_df = pd.DataFrame(X_mask.cpu().numpy()[0,:,dim], columns = [dataset_name])
        X_mask_df["time"]  = time
        X_mask_df["type"] = f"Input_masked_{dim}"
        X_mask_df["dim"] = dim
        #X_mask_df["std"] = 0
        X_masked_df_list.append(X_mask_df)

        X_df = pd.concat(X_df_list)

        time_x_end = X_df.time.max() + 1

        #if (Y_hat.dim()<3): #dimension for obs_dim
        #    Y_hat = Y_hat.unsqueeze(-1)
        
        #for sample in range(Y_hat.shape[0]):
        #for dim in range(Y_hat.shape[-1]):
        std_hat = Y_hat.cpu().numpy()[:,:,dim].std(axis=0)
        Y_hat_fact_df = pd.DataFrame(Y_hat.cpu().numpy()[:,:,dim].mean(axis=0), columns = [dataset_name])
        Y_hat_fact_df = Y_hat_fact_df.where(pd.notnull(Y_hat_fact_df), np.NaN)
        Y_hat_fact_df["time"]  = time#[1:]
        Y_hat_fact_df["type"] = "Factual Prediction Mean"
        Y_hat_fact_df["dim"] = dim
        Y_hat_fact_df["std"] = std_hat#Y_hat.cpu().numpy()[:,:,dim].std(axis=0)
        Y_df_list.append(Y_hat_fact_df)

        #fig = px.line(df, x = "time",y = dataset_name,color="dim", line_dash="type", error_y ="std", title = f"{chart_type} longitudinal predictions - dimension {dim}")
        #fig.data[0].mode = 'lines+markers'
        #fig.data[1].mode = 'lines+markers'
    X_df = pd.concat(X_df_list)
    Y_df = pd.concat(Y_df_list)
    X_masked_df = pd.concat(X_masked_df_list)
    df = pd.concat([X_df, Y_df, X_masked_df])
    df = df.where(pd.notnull(df), np.NaN) #replace(np.nan, None)

    fig = line(
        data_frame= df, 
        x = "time",
        y = dataset_name,
        color="dim", 
        line_dash="type", 
        error_y ="std",
        error_y_mode ='band', 
        title = f"{chart_type} longitudinal predictions - dimension {dim}",
        )
    #fig.update_layout(legend_orientation="h")
    #fig.show()

    if type(logger).__name__ == "WandbLogger":
        logger.experiment.log({f"{chart_type} chart {dim}":fig},step = logger.experiment.step)
    else:
        print("Missing graph")