import argparse
import logging
import os
import pickle
import traceback
from copy import deepcopy
import yaml

from cancer_simulation import get_cancer_sim_data
from data_utils import read_from_file, write_to_file
from process_irregular_data import *
#from trainer import trainer

#python generate_dat.py --coeff 5 --kappa 1 --data_path tumorData_k1/raw --save_raw_datapath ../../tumorData_k1/raw --save_transformed_datapath ../../tumorData_k1/transformed

def init_arg():
    parser = argparse.ArgumentParser()
    parser.add_argument("--coeff", default=2, type=int)
    parser.add_argument("--results_dir", default="results")
    
    parser.add_argument("--data_path", type=str, default=None)
    #parser.add_argument("--use_transformed", default=True)
    parser.add_argument("--multistep", default=True)
    parser.add_argument("--kappa", type=int, default=10)
    parser.add_argument("--lambda_val", type=float, default=1)
    parser.add_argument("--max_samples", type=int, default=1)
    parser.add_argument("--max_horizon", type=int, default=5)
    parser.add_argument("--save_raw_datapath", type=str, default=None)
    parser.add_argument("--save_transformed_datapath", type=str, default=None)
    return parser.parse_args()


if __name__ == "__main__":

    args = init_arg()

    if not os.path.exists( f"../../{args.save_raw_datapath}"):
        print('Creating new folder: '+ f"../../{args.save_raw_datapath}")
        os.makedirs(f"../../{args.save_raw_datapath}")
    if not os.path.exists(f"../../{args.save_transformed_datapath}"):
        print('Creating new folder: '+ f"../../{args.save_transformed_datapath}")
        os.makedirs(f"../../{args.save_transformed_datapath}")


    multistep = str(args.multistep) == "True"

    logging.basicConfig(format="%(levelname)s:%(message)s", level=logging.INFO)
    logging.getLogger().setLevel(logging.INFO)

    strategy = "all"

    coeff = int(args.coeff)

    if args.data_path == None:
        logging.info("Generating dataset")
        pickle_map = get_cancer_sim_data(
            chemo_coeff=args.coeff,
            radio_coeff=args.coeff,
            b_load=True,
            b_save=False,
            model_root=args.results_dir,
        )
    else:
        logging.info(f"Loading dataset from: ../../{args.data_path}/new_cancer_sim_{coeff}_{coeff}.p")
        pickle_map = read_from_file(f"../../{args.data_path}/new_cancer_sim_{coeff}_{coeff}.p")



    kappa = int(args.kappa)

    lambda_val = float(args.lambda_val)

    max_samples = int(args.max_samples)

    max_horizon = int(args.max_horizon)

    

    if args.save_raw_datapath != None:
        logging.info(f"Writing raw data to {args.save_raw_datapath}")
        write_to_file(
            pickle_map,
            f"../../{args.save_raw_datapath}/new_cancer_sim_{coeff}_{coeff}.p",
        )

    logging.info("Transforming dataset")
    #Apply Hawkess process
    pickle_map = transform_data(
        data=pickle_map,
        interpolate=False,
        strategy=strategy,
        sample_prop=1,
        kappa=kappa,
        max_samples=max_samples,
    )



    if args.save_transformed_datapath != None:
        logging.info(f"Writing transformed data to {args.save_transformed_datapath}")
        write_to_file(
            pickle_map,
            f"../../{args.save_transformed_datapath}/new_cancer_sim_{coeff}_{coeff}_kappa_{kappa}.p",
        )

