
# Time Series Anomaly Detection Using Reconstruction and RBF Similarity Score

## Description
This project focuses on anomaly detection in time series data using unsupervised learning methods. Recognizing the limitations of approaches based solely on reconstruction error, especially in high-dimensional datasets, we propose a novel method that incorporates a layer of Radial Basis Function (RBF) neurons within deep learning architectures. This RBF layer fits a nonparametric density in the hidden representation. When the neural network is trained on (predominantly) normal data, then a high RBF output indicates a high density, which in turn implies a high similarity with the normal data. Combining the RBF similarity score with the reconstruction error results in a unique anomaly score that we named the SimRec score. While our method can be adapted to a wide range of architectures, we focus on LSTM and Transformer models.  We evaluate our approach on three real-world benchmark datasets, with results indicating significant improvements over the baselines. Our findings underscore the potential of the SimRec score in capturing subtle anomalies that might be overlooked by scores based on reconstruction error alone, offering a more robust and comprehensive solution for anomaly detection in time series data.

## Environment Setup
- Python version: 3.6.12
- Hydra (Need to be installed) is used for dynamic configuration management. Configuration files are provided and can be found in the 'configs' directory.
- Datasets: All dataset are publicly available

## Instructions
- The primary configuration is loaded using the load_config function. By default, it uses the base_config.yaml file. To specify a different configuration, you can eaily change the the configurations files in the 'configs' directory.
- Run `main.py` to execute the primary functions of the project.

## Files Overview
- `Utils.py`: Utility functions.
- `Transformer_Model.py`: Transformer models implementation.
- `LSTM_Model.py`: LSTM models implementation.
- `main.py`: Main execution script.
- `stages_training.py`: Training stages for the models.
- `evaluation.py`: Model evaluation scripts.
- `solver.py`: Solver functionalities.
- `Training.py`: Training script for models.
- `RBF_Layer.py`: Implementation of the RBF Layer.
- Configuration Files:
    - `base_config.yaml`: Base configuration file.
    - `SimRec_Transformer.yaml`: Configuration for SimRec-Transformer model.
    - `SimRec_LSTM.yaml`: Configuration for SimRec-LSTM model.
    - `LSTM.yaml`: Configuration for the baseline-LSTM model.
    - `Transformer.yaml`: Configuration for the baseline-Transformer model.
    - `PSM.yaml`, `SMD.yaml`, `MSL.yaml`: Dataset-specific configurations.
