#!/usr/bin/env python3
# -*- coding: utf-8 -*-


from Utils import get_data, generate_loaders, set_seed, load_config
from solver import run_experiment
import pickle
import os

##############################

def main(cfg):
    
    # Set the seed for all relevant libraries
    set_seed(42)
    
    #Prepare Dataset    
    (x_train, _), (x_test, y_test_point) = get_data(cfg)
    train_dataloader, test_dataloader = generate_loaders(x_train, x_test, y_test_point, cfg)

    ##############################
    ##############################
    ##############################
    
    seeds = [0, 1, 2, 3, 4]  # List of seeds to use for the experiments

    results = {}  # Dictionary to save the results for each seed
            
    for seed in seeds:
        seed_results = run_experiment(cfg, train_dataloader, test_dataloader, seed, save_mode = False)
        results[seed] = seed_results

    return results


##############################
if __name__ == "__main__":
    #Load Config
    working_dir = os.getcwd()   
    cfg = load_config(working_dir)
    
    mode_type = cfg.mode
    selected_model = cfg.model.type
     
    results = main(cfg)
    
    # Save the results
    with open(f'{cfg.dataset.save_prefix}/results_{cfg.dataset.name}_{selected_model}_mode_{mode_type}_{cfg.initialization}.pkl', 'wb') as f:
        pickle.dump(results, f)
        
        
        