/*
 * Decompiled with CFR 0.152.
 */
package global.oskar.gottagofast.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.fabricmc.loader.api.FabricLoader;

public class ConfigHandler {
    private final Gson Gson = new GsonBuilder().setPrettyPrinting().create();
    private final File configFile = new File(FabricLoader.getInstance().getConfigDirectory(), "gottagofast.json");
    private final Boolean debug = false;

    public ConfigHandler() {
        try (FileReader reader = new FileReader(this.configFile);){
            this.Gson.fromJson((Reader)reader, Config.class);
        }
        catch (Exception e) {
            if (this.debug.booleanValue()) {
                e.printStackTrace();
            }
            this.saveConfig(new Config());
        }
    }

    public Config getConfig() {
        Config config;
        FileReader reader = new FileReader(this.configFile);
        try {
            config = (Config)this.Gson.fromJson((Reader)reader, Config.class);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                if (this.debug.booleanValue()) {
                    e.printStackTrace();
                }
                return new Config();
            }
        }
        reader.close();
        return config;
    }

    private void saveConfig(Config config) {
        block7: {
            try (FileWriter writer = new FileWriter(this.configFile);){
                writer.write(this.Gson.toJson((Object)config));
            }
            catch (IOException e) {
                if (!this.debug.booleanValue()) break block7;
                e.printStackTrace();
            }
        }
    }

    public static class Config {
        private float defaultMaxPlayerSpeed = 1000000.0f;
        private float maxPlayerElytraSpeed = 1000000.0f;
        private float maxPlayerVehicleSpeed = 1000000.0f;

        public float getDefaultMaxPlayerSpeed() {
            return this.defaultMaxPlayerSpeed;
        }

        public float getMaxPlayerElytraSpeed() {
            return this.maxPlayerElytraSpeed;
        }

        public float getMaxPlayerVehicleSpeed() {
            return this.maxPlayerVehicleSpeed;
        }
    }
}

