/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.client.gui.bns;

import com.google.common.base.Splitter;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import me.ichun.mods.ichunutil.client.gui.bns.Fragment;
import me.ichun.mods.ichunutil.client.gui.bns.Rectangle;
import me.ichun.mods.ichunutil.client.gui.bns.Theme;
import me.ichun.mods.ichunutil.client.gui.bns.constraint.Constraint;
import me.ichun.mods.ichunutil.client.gui.bns.window.Window;
import me.ichun.mods.ichunutil.client.gui.bns.window.WindowDock;
import me.ichun.mods.ichunutil.client.gui.bns.window.WindowGreyout;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.View;
import me.ichun.mods.ichunutil.client.render.RenderHelper;
import me.ichun.mods.ichunutil.common.iChunUtil;
import net.minecraft.class_1159;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFW;

public abstract class Workspace
extends class_437
implements Rectangle {
    public static final long CURSOR_ARROW = GLFW.glfwCreateStandardCursor((int)221185);
    public static final long CURSOR_IBEAM = GLFW.glfwCreateStandardCursor((int)221186);
    public static final long CURSOR_CROSSHAIR = GLFW.glfwCreateStandardCursor((int)221187);
    public static final long CURSOR_HAND = GLFW.glfwCreateStandardCursor((int)221188);
    public static final long CURSOR_HRESIZE = GLFW.glfwCreateStandardCursor((int)221189);
    public static final long CURSOR_VRESIZE = GLFW.glfwCreateStandardCursor((int)221190);
    public static final String ELLIPSIS = "\u2026";
    public int ellipsisLength = 0;
    public class_437 lastScreen;
    private boolean hasInit;
    public String lastTooltip;
    public int tooltipCooldown;
    public Theme theme;
    public int renderMinecraftStyle;
    public long cursorState;
    public ArrayList<Window<?, ?>> windows = new ArrayList();

    protected Workspace(class_437 lastScreen, class_2561 title) {
        super(title);
        this.lastScreen = lastScreen;
        this.theme = Theme.getInstance();
        this.renderMinecraftStyle = iChunUtil.configClient.bnsMinecraftStyle;
        if (this.canDockWindows()) {
            this.windows.add(new WindowDock<Workspace>(this));
        }
    }

    public <W extends Workspace> W setTheme(Theme theme) {
        this.theme = theme;
        return (W)this;
    }

    public <W extends Workspace> W setMinecraftStyle(int i) {
        this.renderMinecraftStyle = i;
        return (W)this;
    }

    protected void method_25426() {
        if (!this.hasInit) {
            this.hasInit = true;
            this.ellipsisLength = this.getFontRenderer().method_1727(ELLIPSIS);
            this.windows.forEach((Consumer<Window<?, ?>>)((Consumer<Window>)Fragment::init));
        }
    }

    public boolean hasInit() {
        return this.hasInit;
    }

    public void method_25410(class_310 mc, int width, int height) {
        this.field_22787 = mc;
        this.field_22793 = mc.field_1772;
        this.field_22789 = width;
        this.field_22790 = height;
        this.method_25395(null);
        this.windows.forEach((Consumer<Window<?, ?>>)((Consumer<Window>)window -> window.resize(mc, width, height)));
    }

    public void method_25419() {
        this.field_22787.method_1507(this.lastScreen);
    }

    public void method_25432() {
        GLFW.glfwSetCursor((long)this.field_22787.method_22683().method_4490(), (long)0L);
    }

    public List<Window<?, ?>> method_25396() {
        if (this.canDockWindows()) {
            ArrayList winds = new ArrayList();
            for (int i = 0; i < this.windows.size(); ++i) {
                Window<?, ?> window = this.windows.get(i);
                if (window instanceof WindowDock) {
                    ((WindowDock)window).docked.keySet().forEach(h -> winds.addAll(h.windows()));
                    continue;
                }
                winds.add(window);
            }
            winds.remove(this.getDock());
            return winds;
        }
        return this.windows;
    }

    public void method_25393() {
        this.method_25396().forEach(Fragment::tick);
        --this.tooltipCooldown;
    }

    public void method_25394(class_4587 graphics, int mouseX, int mouseY, float partialTick) {
        this.cursorState = CURSOR_ARROW;
        graphics.method_22903();
        this.method_25420(graphics);
        this.renderWindows(graphics, mouseX, mouseY, partialTick);
        this.renderTooltip(graphics, mouseX, mouseY, partialTick);
        this.resetBackground();
        graphics.method_22909();
        GLFW.glfwSetCursor((long)this.field_22787.method_22683().method_4490(), (long)this.cursorState);
    }

    public void method_25420(class_4587 graphics) {
        if (this.renderMinecraftStyle > 0) {
            super.method_25420(graphics);
        } else {
            RenderSystem.clearColor((float)((float)this.getTheme().workspaceBackground[0] / 255.0f), (float)((float)this.getTheme().workspaceBackground[1] / 255.0f), (float)((float)this.getTheme().workspaceBackground[2] / 255.0f), (float)255.0f);
            RenderSystem.clear((int)16640, (boolean)class_310.field_1703);
        }
    }

    public void resetBackground() {
    }

    public void renderWindows(class_4587 graphics, int mouseX, int mouseY, float partialTick) {
        for (int i = this.windows.size() - 1; i >= 0; --i) {
            Window<?, ?> window = this.windows.get(i);
            graphics.method_22904(0.0, 0.0, 10.0);
            window.method_25394(graphics, mouseX, mouseY, partialTick);
        }
    }

    public void renderTooltip(class_4587 graphics, int mouseX, int mouseY, float partialTick) {
        Fragment<?> topMost = this.getTopMostFragment(mouseX, mouseY);
        if (topMost != null) {
            String tooltip = topMost.tooltip(mouseX, mouseY);
            if (tooltip != null) {
                if (!tooltip.equals(this.lastTooltip)) {
                    this.lastTooltip = tooltip;
                    this.tooltipCooldown = iChunUtil.configClient.bnsTooltipCooldown;
                }
            } else {
                this.lastTooltip = null;
            }
        }
        if (this.lastTooltip != null && this.tooltipCooldown < 0) {
            this.renderTooltip(graphics, this.lastTooltip, mouseX, mouseY);
        }
    }

    public void renderTooltip(class_4587 graphics, @NotNull String tooltip, int mouseX, int mouseY) {
        List textStrings = Splitter.on((String)"\n").splitToList((CharSequence)tooltip);
        if (this.renderMinecraftStyle > 0) {
            ArrayList<class_5250> textLines = new ArrayList<class_5250>();
            for (String s : textStrings) {
                textLines.add(class_2561.method_43470((String)s));
            }
            super.method_30901(graphics, textLines, mouseX, mouseY);
        } else {
            int n;
            ArrayList<class_5250> textLines = new ArrayList<class_5250>();
            for (String s : textStrings) {
                textLines.add(class_2561.method_43470((String)s));
            }
            int screenWidth = this.field_22789;
            int screenHeight = this.field_22790;
            int maxTextWidth = -1;
            class_327 font = this.getFontRenderer();
            RenderSystem.disableDepthTest();
            int tooltipTextWidth = 0;
            for (class_5348 class_53482 : textLines) {
                int textLineWidth = font.method_27525(class_53482);
                if (textLineWidth <= tooltipTextWidth) continue;
                tooltipTextWidth = textLineWidth;
            }
            boolean needsWrap = false;
            boolean bl = true;
            int tooltipX = mouseX + 12;
            if (tooltipX + tooltipTextWidth + 4 > screenWidth && (tooltipX = mouseX - 16 - tooltipTextWidth) < 4) {
                tooltipTextWidth = mouseX > screenWidth / 2 ? mouseX - 12 - 8 : screenWidth - 16 - mouseX;
                needsWrap = true;
            }
            if (maxTextWidth > 0 && tooltipTextWidth > maxTextWidth) {
                tooltipTextWidth = maxTextWidth;
                needsWrap = true;
            }
            if (needsWrap) {
                int wrappedTooltipWidth = 0;
                ArrayList<class_5348> wrappedTextLines = new ArrayList<class_5348>();
                for (int i = 0; i < textLines.size(); ++i) {
                    class_5348 textLine = (class_5348)textLines.get(i);
                    List wrappedLine = font.method_27527().method_27495(textLine, tooltipTextWidth, class_2583.field_24360);
                    if (i == 0) {
                        n = wrappedLine.size();
                    }
                    for (class_5348 line : wrappedLine) {
                        int lineWidth = font.method_27525(line);
                        if (lineWidth > wrappedTooltipWidth) {
                            wrappedTooltipWidth = lineWidth;
                        }
                        wrappedTextLines.add(line);
                    }
                }
                tooltipTextWidth = wrappedTooltipWidth;
                textLines = wrappedTextLines;
                tooltipX = mouseX > screenWidth / 2 ? mouseX - 16 - tooltipTextWidth : mouseX + 12;
            }
            int tooltipY = mouseY - 12;
            int tooltipHeight = 8;
            if (textLines.size() > 1) {
                tooltipHeight += (textLines.size() - 1) * 10;
                if (textLines.size() > n) {
                    tooltipHeight += 2;
                }
            }
            if (tooltipY < 4) {
                tooltipY = 4;
            } else if (tooltipY + tooltipHeight + 4 > screenHeight) {
                tooltipY = screenHeight - tooltipHeight - 4;
            }
            class_4587 stack = graphics;
            int zLevel = 400;
            stack.method_22903();
            class_1159 mat = stack.method_23760().method_23761();
            RenderHelper.drawColour(graphics, this.getTheme().windowBorderActive, 255, (double)(tooltipX - 3), (double)(tooltipY - 3), (double)(tooltipTextWidth + 6), (double)(tooltipHeight + 6), 400.0);
            RenderHelper.drawColour(graphics, this.getTheme().windowBackground, 255, (double)(tooltipX - 2), (double)(tooltipY - 2), (double)(tooltipTextWidth + 4), (double)(tooltipHeight + 4), 400.0);
            class_4597.class_4598 renderType = class_4597.method_22991((class_287)class_289.method_1348().method_1349());
            stack.method_22904(0.0, 0.0, 400.0);
            int tooltipTop = tooltipY;
            for (int lineNumber = 0; lineNumber < textLines.size(); ++lineNumber) {
                class_5348 line = (class_5348)textLines.get(lineNumber);
                if (line != null) {
                    font.method_22942(class_2477.method_10517().method_30934(line), (float)tooltipX, (float)tooltipY, -1, true, mat, (class_4597)renderType, false, 0, 0xF000F0);
                }
                if (lineNumber + 1 == n) {
                    tooltipY += 2;
                }
                tooltipY += 10;
            }
            renderType.method_22993();
            stack.method_22909();
            RenderSystem.enableDepthTest();
        }
    }

    @Nullable
    public <T extends Fragment<?>> T getById(@NotNull String id) {
        T o = null;
        for (class_364 class_3642 : this.method_25396()) {
            if (o != null || !(class_3642 instanceof Fragment)) continue;
            Fragment fragment = (Fragment)class_3642;
            o = fragment.getById(id);
        }
        return o;
    }

    @Nullable
    public <T extends View<?>> T getByViewType(Class<T> clz) {
        List<Window<?, ?>> windows = this.method_25396();
        for (Window<?, ?> window : windows) {
            if (!clz.isAssignableFrom(window.getCurrentView().getClass())) continue;
            return (T)window.getCurrentView();
        }
        return null;
    }

    @Nullable
    public <T extends Window<?, ?>> T getByWindowType(Class<T> clz) {
        List<Window<?, ?>> windows = this.method_25396();
        for (Window<?, ?> window : windows) {
            if (!clz.isAssignableFrom(window.getClass())) continue;
            return (T)window;
        }
        return null;
    }

    @Nullable
    public Fragment<?> getTopMostFragment(double mouseX, double mouseY) {
        List<Window<?, ?>> children = this.method_25396();
        for (Window<?, ?> child : children) {
            Fragment<?> frag = child.getTopMostFragment(mouseX, mouseY);
            if (frag == null) continue;
            return frag;
        }
        return null;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double distX, double distY) {
        return super.method_25403(mouseX, mouseY, button, distX, distY);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        this.method_25398(false);
        return this.method_25399() != null && this.method_25399().method_25406(mouseX, mouseY, button);
    }

    public boolean isObstructed(Window<?, ?> window, double mouseX, double mouseY) {
        for (Window<?, ?> window1 : this.method_25396()) {
            if (!Fragment.isMouseBetween(mouseX, window1.getLeft(), window1.getLeft() + window1.width) || !Fragment.isMouseBetween(mouseY, window1.getTop(), window1.getTop() + window1.height)) continue;
            return window != window1;
        }
        return true;
    }

    public Window<?, ?> addWindow(Window<?, ?> window) {
        if (window.isUnique()) {
            List<Window<?, ?>> allWindows = this.method_25396();
            for (int i = allWindows.size() - 1; i >= 0; --i) {
                Window<?, ?> window1 = allWindows.get(i);
                if (window1.getClass() != window.getClass()) continue;
                if (this.isDocked(window1)) {
                    window1.onClose();
                    this.getDock().removeFromDock(window1);
                    continue;
                }
                this.removeWindow(window1);
            }
        }
        this.windows.add(0, window);
        return window;
    }

    public void removeWindow(Window<?, ?> window) {
        if (this.method_25399() == window) {
            this.method_25395(null);
        }
        window.onClose();
        this.windows.remove(window);
    }

    public void bringToFront(Window<?, ?> window) {
        if (window.canBringToFront() && this.windows.remove(window)) {
            this.addWindow(window);
        }
    }

    public void putInCenter(Window<?, ?> window) {
        if (!this.isDocked(window)) {
            window.pos((int)((double)(this.getWidth() - window.getWidth()) / 2.0), (int)((double)(this.getHeight() - window.getHeight()) / 2.0));
        }
    }

    public void openWindowInCenter(Window<?, ?> window, double widthRatio, double heightRatio, boolean greyout) {
        if (widthRatio <= 1.0) {
            window.setWidth((int)((double)window.getParentWidth() * widthRatio));
        } else {
            window.setWidth((int)widthRatio);
        }
        if (heightRatio <= 1.0) {
            window.setHeight((int)((double)window.getParentHeight() * heightRatio));
        } else {
            window.setHeight((int)heightRatio);
        }
        if (greyout) {
            this.addWindowWithGreyout(window);
        } else {
            this.addWindow(window);
        }
        this.putInCenter(window);
        this.method_25395((class_364)window);
        window.init();
    }

    public void openWindowInCenter(Window<?, ?> window, double widthRatio, double heightRatio) {
        this.openWindowInCenter(window, widthRatio, heightRatio, false);
    }

    public void openWindowInCenter(Window<?, ?> window, boolean greyout) {
        this.openWindowInCenter(window, 0.5, 0.5, greyout);
    }

    public void openWindowInCenter(Window<?, ?> window) {
        this.openWindowInCenter(window, false);
    }

    public void addWindowWithGreyout(Window<?, ?> window) {
        WindowGreyout<Workspace> greyout = new WindowGreyout<Workspace>(this, window);
        this.addWindow(greyout);
        greyout.init();
        this.addWindow(window);
    }

    public boolean canDockWindows() {
        return true;
    }

    public WindowDock<? extends Workspace> getDock() {
        return (WindowDock)this.windows.get(this.windows.size() - 1);
    }

    public WindowDock.DockInfo getDockInfo(double mouseX, double mouseY, boolean dockStack) {
        if (this.canDockWindows()) {
            return this.getDock().getDockInfo(mouseX, mouseY, dockStack);
        }
        return null;
    }

    public void addToDocked(Window<?, ?> docked, Window<?, ?> window) {
        if (this.canDockWindows() && this.getDock().addToDocked(docked, window)) {
            this.removeWindow(window);
        }
    }

    public void addToDock(Window<?, ?> window, Constraint.Property.Type type) {
        if (this.canDockWindows()) {
            this.getDock().addToDock(window, type);
            this.removeWindow(window);
        }
    }

    public void removeFromDock(Window<?, ?> window, boolean addWindow) {
        if (this.canDockWindows()) {
            this.getDock().removeFromDock(window);
            if (addWindow) {
                this.addWindow(window);
            } else {
                this.removeWindow(window);
            }
        }
    }

    public void removeFromDock(Window<?, ?> window) {
        this.removeFromDock(window, true);
    }

    public boolean isDocked(Window<?, ?> window) {
        if (this.canDockWindows()) {
            return this.getDock().isDocked(window);
        }
        return false;
    }

    public boolean sameDockStack(Rectangle window, Rectangle window1) {
        if (this.canDockWindows()) {
            return this.getDock().sameDockStack(window, window1);
        }
        return false;
    }

    @Override
    public int getLeft() {
        return 0;
    }

    @Override
    public int getRight() {
        return this.field_22789;
    }

    @Override
    public int getTop() {
        return 0;
    }

    @Override
    public int getBottom() {
        return this.field_22790;
    }

    @Override
    public int getWidth() {
        return this.field_22789;
    }

    @Override
    public int getHeight() {
        return this.field_22790;
    }

    @Override
    public <W extends Workspace> W getWorkspace() {
        return (W)this;
    }

    @Override
    public class_310 getMinecraft() {
        return this.field_22787;
    }

    @Override
    public Theme getTheme() {
        return this.theme;
    }

    @Override
    public class_327 getFontRenderer() {
        return this.field_22793;
    }

    @Override
    public int renderMinecraftStyle() {
        return this.renderMinecraftStyle;
    }

    public void method_25395(@Nullable class_364 gui) {
        class_364 lastFocused = this.method_25399();
        if (lastFocused instanceof Fragment && gui != lastFocused) {
            ((Fragment)lastFocused).unfocus(gui);
        }
        if (gui instanceof Window) {
            this.bringToFront((Window)gui);
        }
        super.method_25395(gui);
    }

    public static void bindTexture(class_2960 rl) {
        RenderSystem.setShaderTexture((int)0, (class_2960)rl);
    }
}

