/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.client.gui.bns.window;

import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import me.ichun.mods.ichunutil.client.gui.bns.Fragment;
import me.ichun.mods.ichunutil.client.gui.bns.Workspace;
import me.ichun.mods.ichunutil.client.gui.bns.constraint.Constrainable;
import me.ichun.mods.ichunutil.client.gui.bns.constraint.Constraint;
import me.ichun.mods.ichunutil.client.gui.bns.window.Window;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.View;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.ElementList;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.ElementScrollBar;
import net.minecraft.class_310;
import net.minecraft.class_364;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WindowContextMenu<M extends Workspace>
extends Window<M, View<?>> {
    private final ElementList<?> list;
    private int minWidth = 1;
    private boolean killed;

    private WindowContextMenu(M parent) {
        super(parent);
        this.setBorderSize(() -> 1);
        this.setView(new ViewContextMenu(this, ""));
        this.list = (ElementList)((View)this.getCurrentView()).elements.get(1);
        this.disableTitle();
        this.disableDocking();
        this.disableDockStacking();
        this.disableDrag();
        this.disableDragResize();
        this.disableUndocking();
    }

    public ElementList<?> getList() {
        return this.list;
    }

    public void setupAround(double posX, double posY, int minWidth, int yFlipHeight) {
        this.width = this.minWidth = minWidth;
        this.resize(class_310.method_1551(), this.parent.getWidth(), this.parent.getHeight());
        this.height = this.list.getTotalItemHeight() + (Integer)this.borderSize.get() * 2 + this.list.getBorderSize() * 2;
        int pX = (int)posX;
        int pY = (int)posY;
        int screenWidth = this.parent.getWidth();
        int screenHeight = this.parent.getHeight();
        int tooltipX = pX;
        if (tooltipX + minWidth > screenWidth) {
            tooltipX = pX - minWidth;
        }
        int tooltipY = pY;
        int tooltipHeight = this.height;
        if (tooltipY < 0) {
            tooltipY = 0;
        } else if (tooltipY + tooltipHeight > screenHeight) {
            if (tooltipHeight > pY - yFlipHeight) {
                this.height = tooltipHeight = Math.min(Math.max(pY - yFlipHeight, screenHeight - tooltipY) - 2, this.list.getTotalItemHeight() + (Integer)this.borderSize.get() * 2 + this.list.getBorderSize() * 2);
            }
            if (tooltipY + tooltipHeight > screenHeight && (tooltipY = pY - yFlipHeight - tooltipHeight) < 0) {
                tooltipY = screenHeight - tooltipHeight;
            }
        }
        this.constraint.apply();
        this.pos(tooltipX, tooltipY);
        this.resize(class_310.method_1551(), this.parent.getWidth(), this.parent.getHeight());
    }

    @Override
    public int getMinWidth() {
        return this.minWidth;
    }

    @Override
    public void unfocus(@Nullable class_364 guiReplacing) {
        super.unfocus(guiReplacing);
        if (!this.killed) {
            this.killed = true;
            this.parent.removeWindow(this);
        }
    }

    public static <M extends Workspace> WindowContextMenu<M> create(M parent, IContextMenu iContextMenu, double posX, double posY, int minWidth, int yFlipHeight) {
        WindowContextMenu<M> windowContextMenu = new WindowContextMenu<M>(parent);
        ElementList<?> list = windowContextMenu.getList();
        List<?> contextMenuObjects = iContextMenu.getObjects();
        Function<Object, String> nameProvider = iContextMenu.getNameProvider();
        BiConsumer<IContextMenu, ElementList.Item<?>> contextMenuReceiver = iContextMenu.getReceiver();
        contextMenuObjects.forEach(o -> list.addItem(o).addTextWrapper((String)nameProvider.apply(o)).setSelectionHandler(item -> {
            ((Workspace)item.getWorkspace()).method_25395(null);
            contextMenuReceiver.accept(iContextMenu, (ElementList.Item<?>)item);
        }));
        if (((Workspace)windowContextMenu.getWorkspace()).hasInit()) {
            windowContextMenu.init();
        }
        windowContextMenu.setupAround(posX, posY, minWidth, yFlipHeight);
        ((Workspace)windowContextMenu.getWorkspace()).addWindow(windowContextMenu);
        ((Workspace)windowContextMenu.getWorkspace()).method_25395((class_364)windowContextMenu);
        return windowContextMenu;
    }

    private class ViewContextMenu
    extends View<WindowContextMenu<M>> {
        public ViewContextMenu(@NotNull WindowContextMenu<M> parent, String s) {
            super(parent, s);
            ElementScrollBar sv = new ElementScrollBar(this, ElementScrollBar.Orientation.VERTICAL, 0.6f);
            sv.setConstraint(new Constraint(sv).top(this, Constraint.Property.Type.TOP, 0).bottom(this, Constraint.Property.Type.BOTTOM, 0).right(this, Constraint.Property.Type.RIGHT, 0));
            this.elements.add(sv);
            Object list = new ElementList<ViewContextMenu>(this).setScrollVertical(sv);
            ((Fragment)list).setConstraint(new Constraint((Constrainable)list).left(this, Constraint.Property.Type.LEFT, 0).bottom(this, Constraint.Property.Type.BOTTOM, 0).top(this, Constraint.Property.Type.TOP, 0).right(sv, Constraint.Property.Type.LEFT, 0));
            this.elements.add(list);
        }
    }

    public static interface IContextMenu {
        @NotNull
        public List<?> getObjects();

        @NotNull
        public BiConsumer<IContextMenu, ElementList.Item<?>> getReceiver();

        @NotNull
        default public Function<Object, String> getNameProvider() {
            return Object::toString;
        }
    }
}

