/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.client.gui.bns.window;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import me.ichun.mods.ichunutil.client.gui.bns.Fragment;
import me.ichun.mods.ichunutil.client.gui.bns.Rectangle;
import me.ichun.mods.ichunutil.client.gui.bns.Workspace;
import me.ichun.mods.ichunutil.client.gui.bns.constraint.Constraint;
import me.ichun.mods.ichunutil.client.gui.bns.window.Window;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.View;
import me.ichun.mods.ichunutil.common.iChunUtil;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WindowDock<M extends Workspace>
extends Window<M, View<?>> {
    public LinkedHashMap<ArrayListHolder, Constraint.Property.Type> docked = new LinkedHashMap();
    public HashMap<Window<?, ?>, WindowSize> dockedOriSize = new HashMap();
    public HashSet<Constraint.Property.Type> disabledDocks = new HashSet();

    public WindowDock(M parent) {
        super(parent);
        this.size(((Workspace)parent).getWidth(), ((Workspace)parent).getHeight());
        this.setConstraint(Constraint.matchParent(this, parent, 0));
        this.borderSize = () -> iChunUtil.configClient.bnsDockPadding;
        this.titleSize = () -> 0;
    }

    @Override
    public boolean canShowTitle() {
        return false;
    }

    @Override
    public boolean hasTitle() {
        return false;
    }

    @Override
    public boolean canDrag() {
        return false;
    }

    @Override
    public boolean canDragResize() {
        return false;
    }

    @Override
    public boolean canBringToFront() {
        return false;
    }

    @Override
    public boolean canBeDocked() {
        return false;
    }

    @Override
    public boolean canBeUndocked() {
        return false;
    }

    @Override
    public void init() {
        this.constraint.apply();
        this.docked.keySet().forEach(h -> h.windows.forEach((Consumer<Window<?, ?>>)((Consumer<Window>)window -> {
            window.constraint.apply();
            window.resize(class_310.method_1551(), this.width, this.height);
            window.init();
        })));
    }

    @Override
    public void method_25394(class_4587 graphics, int mouseX, int mouseY, float partialTick) {
        ArrayList<ArrayListHolder> keys = new ArrayList<ArrayListHolder>(this.docked.keySet());
        for (int i = keys.size() - 1; i >= 0; --i) {
            ArrayList<Window<?, ?>> windows = ((ArrayListHolder)keys.get((int)i)).windows;
            windows.forEach((Consumer<Window<?, ?>>)((Consumer<Window>)window -> window.method_25394(graphics, mouseX, mouseY, partialTick)));
        }
    }

    @Override
    public void resize(class_310 mc, int width, int height) {
        this.constraint.apply();
        this.docked.keySet().forEach(h -> h.windows.forEach((Consumer<Window<?, ?>>)((Consumer<Window>)window -> {
            window.constraint.apply();
            window.resize(class_310.method_1551(), this.width, this.height);
        })));
    }

    @Override
    public void tick() {
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        return false;
    }

    @Override
    public boolean method_25406(double mouseX, double mouseY, int button) {
        return false;
    }

    @Override
    public boolean method_25403(double mouseX, double mouseY, int button, double distX, double distY) {
        return false;
    }

    @Override
    public boolean method_25401(double mouseX, double mouseY, double scrollY) {
        Window<?, ?> windowOver = this.getWindowOver(mouseX, mouseY);
        if (windowOver != null) {
            return windowOver.method_25401(mouseX, mouseY, scrollY);
        }
        return false;
    }

    @Override
    public boolean method_25405(double mouseX, double mouseY) {
        return !this.parent.isObstructed(this, mouseX, mouseY) && WindowDock.isMouseBetween(mouseX, this.getLeft(), this.getLeft() + this.width) && WindowDock.isMouseBetween(mouseY, this.getTop(), this.getTop() + this.height);
    }

    @Override
    @Nullable
    public Fragment<?> getTopMostFragment(double mouseX, double mouseY) {
        if (this.method_25405(mouseX, mouseY)) {
            Fragment fragment = this;
            for (ArrayListHolder h : this.docked.keySet()) {
                for (Window<?, ?> window : h.windows) {
                    Fragment<?> fragment1 = window.getTopMostFragment(mouseX, mouseY);
                    if (fragment1 == null) continue;
                    fragment = fragment1;
                }
            }
            return fragment;
        }
        return null;
    }

    public boolean isDocked(Window<?, ?> window) {
        for (ArrayListHolder h : this.docked.keySet()) {
            if (!h.windows.contains(window)) continue;
            return true;
        }
        return false;
    }

    public boolean sameDockStack(Rectangle window, Rectangle window1) {
        for (ArrayListHolder h : this.docked.keySet()) {
            if (!h.windows.contains(window)) continue;
            return h.windows.contains(window1);
        }
        return false;
    }

    public void disableDock(Constraint.Property.Type type) {
        this.disabledDocks.add(type);
    }

    @Nullable
    public DockInfo getDockInfo(double mouseX, double mouseY, boolean dockStack) {
        Window<?, ?> window;
        if (dockStack && (window = this.getWindowOver(mouseX, mouseY)) != null && window.canDockStack()) {
            return new DockInfo(window, this.getAnchorType(window));
        }
        double left = 0.0;
        double top = 0.0;
        double right = this.width;
        double bottom = this.height;
        for (Map.Entry<ArrayListHolder, Constraint.Property.Type> e : this.docked.entrySet()) {
            for (Window<?, ?> key : e.getKey().windows) {
                Constraint.Property.Type value = e.getValue();
                switch (value) {
                    case LEFT: {
                        if (!((double)key.getRight() > left)) break;
                        left = key.getRight();
                        break;
                    }
                    case TOP: {
                        if (!((double)key.getBottom() > top)) break;
                        top = key.getBottom();
                        break;
                    }
                    case RIGHT: {
                        if (!((double)key.getLeft() < right)) break;
                        right = key.getLeft();
                        break;
                    }
                    case BOTTOM: {
                        if (!((double)key.getTop() < bottom)) break;
                        bottom = key.getTop();
                    }
                }
            }
        }
        int dockSnap = iChunUtil.configClient.bnsDockBorder;
        if (mouseY >= top && mouseY < bottom) {
            if (mouseX >= left && mouseX < left + (double)dockSnap && !this.disabledDocks.contains((Object)Constraint.Property.Type.LEFT)) {
                return new DockInfo(null, Constraint.Property.Type.LEFT);
            }
            if (mouseX >= right - (double)dockSnap && mouseX < right && !this.disabledDocks.contains((Object)Constraint.Property.Type.RIGHT)) {
                return new DockInfo(null, Constraint.Property.Type.RIGHT);
            }
        }
        if (mouseX >= left && mouseX < right) {
            if (mouseY >= top && mouseY < top + (double)dockSnap && !this.disabledDocks.contains((Object)Constraint.Property.Type.TOP)) {
                return new DockInfo(null, Constraint.Property.Type.TOP);
            }
            if (mouseY >= bottom - (double)dockSnap && bottom < right && !this.disabledDocks.contains((Object)Constraint.Property.Type.BOTTOM)) {
                return new DockInfo(null, Constraint.Property.Type.BOTTOM);
            }
        }
        return null;
    }

    public boolean addToDocked(Window<?, ?> dockedWin, Window<?, ?> window) {
        for (Map.Entry<ArrayListHolder, Constraint.Property.Type> e : this.docked.entrySet()) {
            if (!e.getKey().windows.contains(dockedWin)) continue;
            this.dockedOriSize.put(window, new WindowSize(window.constraint, window.getLeft(), window.getTop(), window.getWidth(), window.getHeight()));
            Constraint.Property.Type dockType = e.getValue();
            ArrayList<Window<?, ?>> dockStack = e.getKey().windows;
            Window<?, ?> lastInStack = dockStack.get(dockStack.size() - 1);
            int maxWidth = -1;
            int maxHeight = -1;
            if (dockType.getAxis().method_10179()) {
                maxWidth = window.width;
                for (Window<?, ?> window1 : dockStack) {
                    if (window1.width <= maxWidth) continue;
                    maxWidth = window1.width;
                }
            } else if (dockType.getAxis().method_10178()) {
                maxHeight = window.height;
                for (Window<?, ?> window1 : dockStack) {
                    if (window1.height <= maxHeight) continue;
                    maxHeight = window1.height;
                }
            }
            Constraint constraint = new Constraint(window);
            Constraint.Property.Type[] values = Constraint.Property.Type.values();
            for (int i = values.length - 1; i >= 0; --i) {
                Constraint.Property.Type type1 = values[i];
                if (type1.equals((Object)Constraint.Property.Type.WIDTH) || type1.equals((Object)Constraint.Property.Type.HEIGHT)) continue;
                Window<?, ?> constrainable = this.getWindowAnchor(lastInStack, type1);
                if (dockType.getAxis().method_10179() && type1 == Constraint.Property.Type.TOP || dockType.getAxis().method_10178() && type1 == Constraint.Property.Type.LEFT) {
                    constrainable = lastInStack;
                    lastInStack.constraint.type(type1.getOpposite(), null, null, 0);
                    if (type1 == Constraint.Property.Type.TOP) {
                        lastInStack.setHeight(this.dockedOriSize.get(lastInStack).height);
                    } else {
                        lastInStack.setWidth(this.dockedOriSize.get(lastInStack).width);
                    }
                }
                if (type1 == dockType.getOpposite()) continue;
                constraint = constrainable != null && !(constrainable instanceof WindowDock) ? constraint.type(type1, constrainable, type1.getOpposite(), -window.borderSize.get().intValue() + (Integer)this.borderSize.get()) : constraint.type(type1, this, type1, -window.borderSize.get().intValue() + (Integer)this.borderSize.get());
            }
            e.getKey().windows.add(window);
            window.setConstraint(constraint);
            for (Window<?, ?> window1 : dockStack) {
                if (maxWidth >= 0) {
                    window1.setWidth(maxWidth);
                } else if (maxHeight >= 0) {
                    window1.setHeight(maxHeight);
                }
                window1.constraint.apply();
                if (!((Workspace)this.getWorkspace()).hasInit()) continue;
                window1.resize(class_310.method_1551(), this.width, this.height);
            }
            return true;
        }
        return false;
    }

    public void addToDock(Window<?, ?> window, Constraint.Property.Type type) {
        this.dockedOriSize.put(window, new WindowSize(window.constraint, window.getLeft(), window.getTop(), window.getWidth(), window.getHeight()));
        Constraint constraint = new Constraint(window);
        for (Constraint.Property.Type type1 : Constraint.Property.Type.values()) {
            if (type1.equals((Object)Constraint.Property.Type.WIDTH) || type1.equals((Object)Constraint.Property.Type.HEIGHT)) continue;
            Rectangle constrainable = this.getAnchor(type1);
            if (type1 == type.getOpposite()) continue;
            constraint = constrainable != null ? constraint.type(type1, constrainable, type1.getOpposite(), -window.borderSize.get().intValue() + (Integer)this.borderSize.get()) : constraint.type(type1, this, type1, -window.borderSize.get().intValue() + (Integer)this.borderSize.get());
        }
        ArrayList windows = new ArrayList();
        windows.add(window);
        this.docked.put(new ArrayListHolder(windows), type);
        window.setConstraint(constraint);
        window.constraint.apply();
        if (((Workspace)this.getWorkspace()).hasInit()) {
            window.resize(class_310.method_1551(), this.width, this.height);
        }
    }

    public void removeFromDock(Window<?, ?> window) {
        boolean redoConstraints = false;
        Iterator<Map.Entry<ArrayListHolder, Constraint.Property.Type>> iterator = this.docked.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<ArrayListHolder, Constraint.Property.Type> e = iterator.next();
            ArrayList<Window<?, ?>> windows = e.getKey().windows;
            EnumMap<Constraint.Property.Type, Constraint.Property> anchors = new EnumMap<Constraint.Property.Type, Constraint.Property>(Constraint.Property.Type.class);
            if (redoConstraints || windows.contains(window)) {
                for (Constraint.Property.Type type2 : Constraint.Property.Type.values()) {
                    Constraint.Property stackAnchor;
                    if (type2.equals((Object)Constraint.Property.Type.WIDTH) || type2.equals((Object)Constraint.Property.Type.HEIGHT) || (stackAnchor = this.getStackAnchor(windows, type2)) == null) continue;
                    anchors.put(type2, stackAnchor);
                }
            }
            if (windows.contains(window)) {
                redoConstraints = true;
                if (windows.size() == 1) {
                    iterator.remove();
                    continue;
                }
                windows.remove(window);
            }
            if (!redoConstraints) continue;
            Constraint.Property.Type dockType = e.getValue();
            for (int i = 0; i < windows.size(); ++i) {
                Window<?, ?> dockWindow = windows.get(i);
                if (i == 0) {
                    Constraint constraint = new Constraint(dockWindow);
                    anchors.forEach((type, property) -> {
                        if (property.getReference() == window) {
                            Rectangle constrainable = this.getAnchor((Constraint.Property.Type)((Object)type), dockWindow);
                            if (constrainable != null && constrainable != dockWindow) {
                                constraint.type((Constraint.Property.Type)((Object)type), constrainable, type.getOpposite(), -dockWindow.borderSize.get().intValue() + (Integer)this.borderSize.get());
                            } else {
                                constraint.type((Constraint.Property.Type)((Object)type), this, (Constraint.Property.Type)((Object)type), -dockWindow.borderSize.get().intValue() + (Integer)this.borderSize.get());
                            }
                        } else {
                            constraint.type((Constraint.Property.Type)((Object)type), property.getReference(), property.getType(), property.getDist());
                        }
                    });
                    dockWindow.setConstraint(constraint);
                    continue;
                }
                Window<?, ?> lastInStack = windows.get(i - 1);
                Constraint constraint = new Constraint(dockWindow);
                Constraint.Property.Type[] values = Constraint.Property.Type.values();
                for (int ii = values.length - 1; ii >= 0; --ii) {
                    Constraint.Property.Type type1 = values[ii];
                    if (type1.equals((Object)Constraint.Property.Type.WIDTH) || type1.equals((Object)Constraint.Property.Type.HEIGHT)) continue;
                    Window<?, ?> constrainable = this.getWindowAnchor(lastInStack, type1);
                    if (dockType.getAxis().method_10179() && type1 == Constraint.Property.Type.TOP || dockType.getAxis().method_10178() && type1 == Constraint.Property.Type.LEFT) {
                        constrainable = lastInStack;
                        lastInStack.constraint.type(type1.getOpposite(), null, null, 0);
                        if (type1 == Constraint.Property.Type.TOP) {
                            lastInStack.setHeight(this.dockedOriSize.get(lastInStack).height);
                        } else {
                            lastInStack.setWidth(this.dockedOriSize.get(lastInStack).width);
                        }
                    }
                    if (type1 == dockType.getOpposite()) continue;
                    constraint = constrainable != null && !(constrainable instanceof WindowDock) ? constraint.type(type1, constrainable, type1.getOpposite(), -dockWindow.borderSize.get().intValue() + (Integer)this.borderSize.get()) : constraint.type(type1, this, type1, -dockWindow.borderSize.get().intValue() + (Integer)this.borderSize.get());
                }
                dockWindow.setConstraint(constraint);
            }
            for (Window<?, ?> window1 : windows) {
                window1.constraint.apply();
                if (!((Workspace)this.getWorkspace()).hasInit()) continue;
                window1.resize(class_310.method_1551(), this.width, this.height);
            }
        }
        WindowSize size = this.dockedOriSize.get(window);
        window.setConstraint(size.constraint);
        if (size.x != 0 || size.y != 0) {
            window.setLeft(size.x);
            window.setTop(size.y);
        }
        window.setWidth(size.width);
        window.setHeight(size.height);
        window.resize(class_310.method_1551(), ((Workspace)window.parent).getWidth(), ((Workspace)window.parent).getHeight());
        this.dockedOriSize.remove(window);
    }

    @Nullable
    public Rectangle getAnchor(Constraint.Property.Type type) {
        return this.getAnchor(type, null);
    }

    @Nullable
    public Rectangle getAnchor(Constraint.Property.Type type, Rectangle ignored) {
        Rectangle typeMost = null;
        for (Map.Entry<ArrayListHolder, Constraint.Property.Type> e : this.docked.entrySet()) {
            if (e.getValue() != type || ignored != null && e.getKey().windows.contains(ignored)) continue;
            typeMost = e.getKey().windows.get(0);
        }
        return typeMost;
    }

    @Nullable
    public Rectangle getWindowAnchor(Window<?, ?> window, Constraint.Property.Type type) {
        return window.constraint.get(type).getReference();
    }

    @Nullable
    public Constraint.Property getStackAnchor(ArrayList<Window<?, ?>> stack, Constraint.Property.Type type) {
        for (Window<?, ?> window : stack) {
            Constraint.Property anchor = window.constraint.get(type);
            if (anchor == Constraint.Property.NONE || stack.contains(anchor.getReference())) continue;
            return anchor;
        }
        return null;
    }

    public Constraint.Property.Type getAnchorType(Window<?, ?> window) {
        for (Map.Entry<ArrayListHolder, Constraint.Property.Type> e : this.docked.entrySet()) {
            if (!e.getKey().windows.contains(window)) continue;
            return e.getValue();
        }
        return null;
    }

    public Window<?, ?> getWindowOver(double mouseX, double mouseY) {
        for (ArrayListHolder h : this.docked.keySet()) {
            for (Window<?, ?> window : h.windows) {
                if (!window.method_25405(mouseX, mouseY)) continue;
                return window;
            }
        }
        return null;
    }

    @NotNull
    public ArrayList<Window<?, ?>> getDockStack(Window<?, ?> window) {
        for (ArrayListHolder h : this.docked.keySet()) {
            if (!h.windows.contains(window)) continue;
            return h.windows;
        }
        return new ArrayList();
    }

    public void edgeGrab(Window<?, ?> draggedWindow, double mouseX, double mouseY, Window.EdgeGrab edgeGrab) {
        Constraint.Property.Type anchorType = this.getAnchorType(draggedWindow);
        if (anchorType != null && (anchorType.getAxis().method_10179() && edgeGrab.left && draggedWindow.constraint.get(Constraint.Property.Type.LEFT) == Constraint.Property.NONE || anchorType.getAxis().method_10179() && edgeGrab.right && draggedWindow.constraint.get(Constraint.Property.Type.RIGHT) == Constraint.Property.NONE || anchorType.getAxis().method_10178() && edgeGrab.top && draggedWindow.constraint.get(Constraint.Property.Type.TOP) == Constraint.Property.NONE || anchorType.getAxis().method_10178() && edgeGrab.bottom && draggedWindow.constraint.get(Constraint.Property.Type.BOTTOM) == Constraint.Property.NONE)) {
            ArrayList<Window<?, ?>> dockStack = this.getDockStack(draggedWindow);
            for (int i = 0; i < dockStack.size(); ++i) {
                Window<?, ?> window = dockStack.get(i);
                if (window == draggedWindow) continue;
                window.dragResize(mouseX, mouseY, edgeGrab);
            }
        }
        ((Workspace)this.getWorkspace()).getDock().init();
    }

    public record ArrayListHolder(ArrayList<Window<?, ?>> windows) {
    }

    public record DockInfo(@Nullable Window<?, ?> window, @Nullable Constraint.Property.Type type) {
    }

    public record WindowSize(Constraint constraint, int x, int y, int width, int height) {
    }
}

