/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.client.gui.bns.window.view.element;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import me.ichun.mods.ichunutil.client.gui.bns.Fragment;
import me.ichun.mods.ichunutil.client.gui.bns.Workspace;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.Element;
import me.ichun.mods.ichunutil.common.iChunUtil;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4587;
import net.minecraft.class_5481;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ElementTextField
extends Element<Fragment<?>> {
    public static final Predicate<String> INTEGERS = s -> {
        if (s.isEmpty() || s.equals("-")) {
            return true;
        }
        try {
            if (s.contains(".")) {
                return false;
            }
            Integer.parseInt(s);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    };
    public static final Predicate<String> NUMBERS = s -> {
        if (s.isEmpty() || s.equals("-")) {
            return true;
        }
        try {
            if (s.contains("f") || s.contains("d") || s.contains("F") || s.contains("D")) {
                return false;
            }
            Double.parseDouble(s);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    };
    public static final Predicate<String> FILE_SAFE = s -> {
        String[] invalidChars;
        if (s.isEmpty()) {
            return true;
        }
        for (String c : invalidChars = new String[]{"\\", "/", ":", "*", "?", "\"", "<", ">", "|"}) {
            if (!s.contains(c)) continue;
            return false;
        }
        return !s.startsWith(".");
    };
    protected class_342 widget;
    private String defaultText = "";
    private int maxStringLength = Short.MAX_VALUE;
    private Predicate<String> validator = s -> true;
    private BiFunction<String, Integer, class_5481> textFormatter = (s, cursorPos) -> class_5481.method_30747((String)s, (class_2583)class_2583.field_24360);
    @Nullable
    private Consumer<String> responder;
    @Nullable
    private Consumer<String> enterResponder;
    private int lastLeft;
    private int lastTop;

    public ElementTextField(@NotNull Fragment parent) {
        super(parent);
    }

    public <T extends ElementTextField> T setDefaultText(String s) {
        this.defaultText = s;
        return (T)this;
    }

    public <T extends ElementTextField> T setValidator(Predicate<String> validator) {
        this.validator = validator;
        return (T)this;
    }

    public Predicate<String> getValidator() {
        return this.validator;
    }

    public <T extends ElementTextField> T setResponder(Consumer<String> responder) {
        this.responder = responder;
        return (T)this;
    }

    public Consumer<String> getResponder() {
        return this.responder;
    }

    public <T extends ElementTextField> T setEnterResponder(Consumer<String> responder) {
        this.enterResponder = responder;
        return (T)this;
    }

    public <T extends ElementTextField> T setMaxStringLength(int i) {
        this.maxStringLength = i;
        return (T)this;
    }

    public <T extends ElementTextField> T setTextFormatter(BiFunction<String, Integer, class_5481> textFormatter) {
        this.textFormatter = textFormatter;
        return (T)this;
    }

    @Override
    public void init() {
        super.init();
        this.widget = new class_342(this.getFontRenderer(), this.getLeft(), this.getTop(), this.width, this.height, (class_2561)class_2561.method_43470((String)"Text Field"));
        this.widget.method_1880(this.maxStringLength);
        this.widget.method_1852(this.defaultText);
        this.widget.method_1890(this.validator);
        this.widget.method_1863(this.responder);
        this.widget.method_1854(this.textFormatter);
        this.adjustWidget();
        this.lastLeft = this.getLeft();
        this.lastTop = this.getTop();
    }

    @Override
    public void tick() {
        super.tick();
    }

    @Override
    public void method_25394(class_4587 graphics, int mouseX, int mouseY, float partialTick) {
        if (this.method_25405(mouseX, mouseY)) {
            ((Workspace)this.getWorkspace()).cursorState = Workspace.CURSOR_IBEAM;
        }
        if (this.lastLeft != this.getLeft() || this.lastTop != this.getTop()) {
            this.adjustWidget();
            this.lastLeft = this.getLeft();
            this.lastTop = this.getTop();
        }
        this.drawTextBox(graphics, mouseX, mouseY, partialTick);
    }

    public void drawTextBox(class_4587 graphics, int mouseX, int mouseY, float partialTick) {
        if (this.renderMinecraftStyle() > 0) {
            this.widget.method_1858(true);
            this.widget.method_25394(graphics, mouseX, mouseY, partialTick);
        } else {
            class_4587 stack = graphics;
            int[] colour = this.method_25405(mouseX, mouseY) ? this.getTheme().elementInputBackgroundHover : this.getTheme().elementInputBackgroundInactive;
            this.fill(graphics, this.getTheme().elementInputBorder, 0);
            this.fill(graphics, colour, 1);
            this.widget.method_1858(false);
            this.widget.method_25394(graphics, mouseX, mouseY, partialTick);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public void resize(class_310 mc, int width, int height) {
        super.resize(mc, width, height);
        this.adjustWidget();
    }

    public void adjustWidget() {
        if (this.widget != null) {
            if (this.renderMinecraftStyle() > 0) {
                this.widget.field_22760 = this.getLeft() + 1;
                this.widget.field_22761 = this.getTop() + 1;
                this.widget.method_25358(this.width - 2);
                this.widget.field_22759 = this.height - 2;
            } else {
                this.widget.field_22760 = this.getLeft() + 5;
                int n = this.getTop() + 1;
                Objects.requireNonNull(this.getFontRenderer());
                this.widget.field_22761 = n + (this.height - 9) / 2;
                this.widget.method_25358(this.width - 6);
                this.widget.field_22759 = this.height - 2;
            }
        }
    }

    public boolean method_25404(int keyCode, int p_keyPressed_2_, int p_keyPressed_3_) {
        boolean flag = super.method_25404(keyCode, p_keyPressed_2_, p_keyPressed_3_);
        if ((keyCode == 257 || keyCode == 335) && this.enterResponder != null) {
            this.enterResponder.accept(this.getText());
        }
        return flag;
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.method_25405(mouseX, mouseY)) {
            this.focus();
            if (button == 1) {
                this.widget.method_1852("");
            } else if (button == 2) {
                this.widget.method_1867(class_310.method_1551().field_1774.method_1460());
            }
            this.widget.method_25402(mouseX, mouseY, button);
            return true;
        }
        return false;
    }

    public void focus() {
        this.method_25395((class_364)this.widget);
        this.widget.method_1876(true);
    }

    @Override
    public void unfocus(@Nullable class_364 guiReplacing) {
        super.unfocus(guiReplacing);
        this.widget.method_1876(false);
        this.method_25395(null);
    }

    @Override
    public boolean method_25407(boolean direction) {
        if (((Fragment)this.parent).method_25399() != this) {
            this.method_25395((class_364)this.widget);
            this.widget.method_1876(true);
            return true;
        }
        return false;
    }

    public void setText(@NotNull String s) {
        if (this.widget == null) {
            iChunUtil.LOGGER.error("You're trying to set a text field widget whilst it is still null. Use setDefaultText instead");
            return;
        }
        this.widget.method_1852(s);
    }

    public String getText() {
        return this.widget.method_1882();
    }

    public class_342 getTextField() {
        return this.widget;
    }

    @Override
    public int getMinHeight() {
        return 12;
    }
}

