/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.util.Random;
import net.minecraft.class_1159;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_757;

public class RenderHelper {
    public static void drawTexture(class_4587 stack, class_2960 resource, double posX, double posY, double width, double height, double zLevel) {
        RenderSystem.setShaderTexture((int)0, (class_2960)resource);
        RenderHelper.draw(stack, posX, posY, width, height, zLevel);
    }

    public static void draw(class_4587 stack, double posX, double posY, double width, double height, double zLevel) {
        RenderHelper.draw(stack, posX, posY, width, height, zLevel, 0.0, 1.0, 0.0, 1.0);
    }

    public static void draw(class_4587 stack, double posX, double posY, double width, double height, double zLevel, double u1, double u2, double v1, double v2) {
        RenderSystem.setShader(class_757::method_34542);
        class_1159 matrix = stack.method_23760().method_23761();
        class_289 tessellator = class_289.method_1348();
        class_287 bufferbuilder = tessellator.method_1349();
        bufferbuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        bufferbuilder.method_22918(matrix, (float)posX, (float)(posY + height), (float)zLevel).method_22913((float)u1, (float)v2).method_1344();
        bufferbuilder.method_22918(matrix, (float)(posX + width), (float)(posY + height), (float)zLevel).method_22913((float)u2, (float)v2).method_1344();
        bufferbuilder.method_22918(matrix, (float)(posX + width), (float)posY, (float)zLevel).method_22913((float)u2, (float)v1).method_1344();
        bufferbuilder.method_22918(matrix, (float)posX, (float)posY, (float)zLevel).method_22913((float)u1, (float)v1).method_1344();
        tessellator.method_1350();
    }

    public static void startDrawBatch() {
        RenderSystem.setShader(class_757::method_34542);
        class_289 tessellator = class_289.method_1348();
        class_287 bufferbuilder = tessellator.method_1349();
        bufferbuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
    }

    public static void drawBatch(class_4587 stack, double posX, double posY, double width, double height, double zLevel, double u1, double u2, double v1, double v2) {
        class_1159 matrix = stack.method_23760().method_23761();
        class_289 tessellator = class_289.method_1348();
        class_287 bufferbuilder = tessellator.method_1349();
        bufferbuilder.method_22918(matrix, (float)posX, (float)(posY + height), (float)zLevel).method_22913((float)u1, (float)v2).method_1344();
        bufferbuilder.method_22918(matrix, (float)(posX + width), (float)(posY + height), (float)zLevel).method_22913((float)u2, (float)v2).method_1344();
        bufferbuilder.method_22918(matrix, (float)(posX + width), (float)posY, (float)zLevel).method_22913((float)u2, (float)v1).method_1344();
        bufferbuilder.method_22918(matrix, (float)posX, (float)posY, (float)zLevel).method_22913((float)u1, (float)v1).method_1344();
    }

    public static void endDrawBatch() {
        class_289.method_1348().method_1350();
    }

    public static void drawColour(class_4587 graphics, int colour, int alpha, double posX, double posY, double width, double height, double zLevel) {
        int r = colour >> 16 & 0xFF;
        int g = colour >> 8 & 0xFF;
        int b = colour & 0xFF;
        RenderHelper.drawColour(graphics, r, g, b, alpha, posX, posY, width, height, zLevel);
    }

    public static void drawColour(class_4587 graphics, int[] rgb, int alpha, double posX, double posY, double width, double height, double zLevel) {
        RenderHelper.drawColour(graphics, rgb[0], rgb[1], rgb[2], alpha, posX, posY, width, height, zLevel);
    }

    public static void drawColour(class_4587 graphics, int r, int g, int b, int alpha, double posX, double posY, double width, double height, double zLevel) {
        if (width <= 0.0 || height <= 0.0) {
            return;
        }
        RenderSystem.setShader(class_757::method_34540);
        class_1159 matrix = graphics.method_23760().method_23761();
        class_289 tessellator = class_289.method_1348();
        class_287 bufferbuilder = tessellator.method_1349();
        bufferbuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        bufferbuilder.method_22918(matrix, (float)posX, (float)(posY + height), (float)zLevel).method_1336(r, g, b, alpha).method_1344();
        bufferbuilder.method_22918(matrix, (float)(posX + width), (float)(posY + height), (float)zLevel).method_1336(r, g, b, alpha).method_1344();
        bufferbuilder.method_22918(matrix, (float)(posX + width), (float)posY, (float)zLevel).method_1336(r, g, b, alpha).method_1344();
        bufferbuilder.method_22918(matrix, (float)posX, (float)posY, (float)zLevel).method_1336(r, g, b, alpha).method_1344();
        tessellator.method_1350();
    }

    public static void colour(int color) {
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)1.0f);
    }

    public static void colour(int color, float alpha) {
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)alpha);
    }

    public static int getRandomColourFromString(String s) {
        Random rand = new Random();
        rand.setSeed(Math.abs(s.hashCode() * 1000));
        int clr = Math.round(1.6777215E7f * rand.nextFloat());
        float[] hsb = new float[3];
        Color.RGBtoHSB(clr >> 16 & 0xFF, clr >> 8 & 0xFF, clr & 0xFF, hsb);
        hsb[2] = 0.65f + 0.25f * hsb[2];
        clr = Color.HSBtoRGB(hsb[0], hsb[1], hsb[2]);
        return clr;
    }

    public static void startGlScissor(int x, int y, int width, int height) {
        class_310 mc = class_310.method_1551();
        double scaleW = (double)mc.method_22683().method_4489() / (double)mc.method_22683().method_4486();
        double scaleH = (double)mc.method_22683().method_4506() / (double)mc.method_22683().method_4502();
        if (width <= 0 || height <= 0) {
            return;
        }
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        RenderSystem.enableScissor((int)((int)Math.floor((double)x * scaleW)), (int)((int)Math.floor((double)mc.method_22683().method_4506() - (double)(y + height) * scaleH)), (int)((int)Math.floor((double)(x + width) * scaleW) - (int)Math.floor((double)x * scaleW)), (int)((int)Math.floor((double)mc.method_22683().method_4506() - (double)y * scaleH) - (int)Math.floor((double)mc.method_22683().method_4506() - (double)(y + height) * scaleH)));
    }

    public static void endGlScissor() {
        RenderSystem.disableScissor();
    }

    public static void renderTestScissor(class_4587 graphics) {
        class_310 mc = class_310.method_1551();
        RenderHelper.startGlScissor(mc.method_22683().method_4486() / 2 - 50, mc.method_22683().method_4502() / 2 - 50, 100, 100);
        RenderHelper.drawColour(graphics, 0xFFFFFF, 255, 0.0, 0.0, (double)mc.method_22683().method_4486(), (double)mc.method_22683().method_4502(), 0.0);
        RenderHelper.endGlScissor();
    }
}

