/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.common.config;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiFunction;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.ElementList;
import me.ichun.mods.ichunutil.client.key.KeyBind;
import me.ichun.mods.ichunutil.common.config.ConfigToToml;
import me.ichun.mods.ichunutil.common.config.annotations.CategoryDivider;
import me.ichun.mods.ichunutil.common.config.annotations.Prop;
import me.ichun.mods.ichunutil.common.iChunUtil;
import me.ichun.mods.ichunutil.loader.Env;
import me.ichun.shadow.com.moandjiezana.toml.Toml;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_156;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ConfigBase
implements Comparable<ConfigBase> {
    @Prop
    public static final HashMap<String, String> DEFAULT_CATEGORY_COMMENTS = (HashMap)class_156.method_654(new HashMap(), map -> {
        map.put("general", "These configs are general configs that don't fit any other category.");
        map.put("gameplay", "These configs affect the gameplay while using the mod.");
        map.put("global", "These configs affect both servers and clients that load the mod.");
        map.put("serverOnly", "These configs affect only the server that loads the mod.");
        map.put("clientOnly", "These configs affect only the client that loads the mod.");
        map.put("block", "These configs affect the blocks in the mod.");
    });
    public static final Set<ConfigBase> CONFIGS = Collections.synchronizedSet(new TreeSet(Comparator.naturalOrder()));
    public final transient TreeSet<Category> categories = new TreeSet(Comparator.naturalOrder());
    @Environment(value=EnvType.CLIENT)
    public transient HashMap<String, BiFunction<Category.Entry, ElementList.Item<?>, Boolean>> guiElementOverrides;
    @NotNull
    private transient String fileName;
    private transient Runnable saveMethod = null;
    private transient String fieldCache = null;

    public ConfigBase(String ... name) {
        CONFIGS.add(this);
        this.fileName = name.length > 0 && !name[0].isEmpty() ? name[0] : this.getModId() + "-" + this.getConfigType().toString().toLowerCase(Locale.ROOT) + ".toml";
        if (this.addToSubfolder()) {
            this.fileName = this.getModId() + "/" + this.fileName;
        }
        if (iChunUtil.d().getSide().isClient()) {
            this.guiElementOverrides = new HashMap();
            this.registerGuiElementOverrides();
        } else if (this.getConfigType() == Type.CLIENT) {
            throw new RuntimeException("You're creating a CLIENT config on a SERVER! Bad! Mod: " + this.getConfigName());
        }
    }

    public void setSaveMethod(Runnable saveMethod) {
        this.saveMethod = saveMethod;
    }

    public String getFileName() {
        return this.fileName;
    }

    public boolean addToSubfolder() {
        return false;
    }

    @NotNull
    public abstract String getModId();

    @NotNull
    public abstract String getConfigName();

    public Type getConfigType() {
        return Type.COMMON;
    }

    public void compile() {
        Map localization;
        try (InputStream in = this.getClass().getResourceAsStream("/assets/" + this.getModId() + "/lang/en_us.json");){
            localization = (Map)new Gson().fromJson((Reader)new InputStreamReader(in, StandardCharsets.UTF_8), new TypeToken<Map<String, String>>(){}.getType());
        }
        catch (IOException | NullPointerException e) {
            localization = new HashMap();
            iChunUtil.LOGGER.warn("Error getting localization file for config {}:{}", new Object[]{this.getModId(), this.getConfigName(), e});
        }
        Field[] fields = this.getClass().getDeclaredFields();
        Category lastCat = null;
        for (Field field : fields) {
            String comment;
            field.setAccessible(true);
            if (!ConfigBase.isValidField(field)) continue;
            @NotNull Prop props = field.isAnnotationPresent(Prop.class) ? field.getAnnotation(Prop.class) : ConfigBase.class.getDeclaredFields()[0].getAnnotation(Prop.class);
            @NotNull Env[] envs = props.env();
            boolean pass = false;
            for (Env env : envs) {
                if (env != Env.ALL && !env.equals((Object)iChunUtil.d().env())) continue;
                pass = true;
                break;
            }
            if (!pass) continue;
            if (field.isAnnotationPresent(CategoryDivider.class)) {
                CategoryDivider divider = field.getAnnotation(CategoryDivider.class);
                if (divider.name().isEmpty()) {
                    throw new RuntimeException("WHY are you defining AN EMPTY CATEGORY?!");
                }
                Map finalLocalization = localization;
                lastCat = this.categories.stream().filter(cat -> cat.name.equals(divider.name())).findFirst().orElseGet(() -> {
                    String comment;
                    String commentKey = "config." + this.getModId() + ".cat." + divider.name() + ".desc";
                    if (!divider.comment().equals("undefined")) {
                        comment = divider.comment();
                    } else if (finalLocalization.containsKey(commentKey)) {
                        comment = (String)finalLocalization.get(commentKey);
                    } else if (DEFAULT_CATEGORY_COMMENTS.containsKey(divider.name())) {
                        commentKey = "config.ichunutil.cat." + divider.name() + ".desc";
                        comment = DEFAULT_CATEGORY_COMMENTS.get(divider.name());
                    } else {
                        comment = null;
                        if (iChunUtil.d().isDevEnvironment()) {
                            iChunUtil.LOGGER.warn("Config category {} from mod {} for config {} has no localisation.", new Object[]{divider.name(), this.getModId(), this.getConfigName()});
                        }
                    }
                    Category newCat = new Category(divider.name(), comment, commentKey, divider.showInGui());
                    this.categories.add(newCat);
                    return newCat;
                });
            } else if (lastCat == null) {
                lastCat = new Category("general", DEFAULT_CATEGORY_COMMENTS.get("general"), "config.ichunutil.cat.general.desc", true);
                this.categories.add(lastCat);
            }
            String commentKey = "config." + this.getModId() + ".prop." + field.getName() + ".desc";
            if (!props.comment().equals("undefined")) {
                comment = props.comment();
            } else if (localization.containsKey(commentKey)) {
                comment = (String)localization.get(commentKey);
            } else {
                comment = null;
                if (iChunUtil.d().isDevEnvironment()) {
                    iChunUtil.LOGGER.warn("Config property {} from mod {} for config {} has no localisation.", new Object[]{field.getName(), this.getModId(), this.getConfigName()});
                }
            }
            Object o = null;
            try {
                field.setAccessible(true);
                o = field.get(this);
            }
            catch (IllegalAccessException | IllegalStateException e) {
                iChunUtil.LOGGER.error("Error reading config {} for field {}", (Object)this.getConfigName(), (Object)field.getName());
            }
            if (o == null) {
                throw new IllegalStateException("Field " + field.getName() + " from config " + this.getClass().getName() + " has no value!");
            }
            lastCat.addField(field, props, comment, commentKey, o);
        }
    }

    public void cache() {
        this.fieldCache = ConfigToToml.convertToToml(this, true);
    }

    public void restoreFromCache() {
        if (this.fieldCache != null) {
            try {
                ConfigToToml.assignValuesFromToml(this, new Toml().read(this.fieldCache), true);
            }
            catch (IllegalAccessException | IllegalStateException e) {
                iChunUtil.LOGGER.error("Error restoring config {} after disconnecting from server.", (Object)this.fileName, (Object)e);
            }
        } else {
            iChunUtil.LOGGER.error("Trying to restore from cache for config {} with no cache!", (Object)this.fileName);
        }
    }

    public void onPropertyChanged(boolean file, String name, Field field, Object oldObj, Object newObj) {
    }

    public void onConfigLoaded() {
    }

    public void registerGuiElementOverrides() {
    }

    public void save() {
        this.saveMethod.run();
    }

    public Method getValidatorMethod(String s) {
        try {
            Method method = this.getClass().getDeclaredMethod(s, Object.class);
            method.setAccessible(true);
            return method;
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Can't find proper validator \"" + s + "\"", e);
        }
    }

    public boolean validate(Method m, Object o) {
        try {
            return (Boolean)m.invoke((Object)this, o);
        }
        catch (IllegalAccessException | InvocationTargetException ex) {
            throw new RuntimeException("Error validating using method\"" + m.getName() + "\" for object " + o, ex);
        }
    }

    @Nullable
    @Environment(value=EnvType.CLIENT)
    public String getLocalisedName(Category category, boolean comment) {
        String suffix = comment ? ".desc" : ".name";
        String key = comment ? category.commentKey : "config." + this.getModId() + ".cat." + category.name + suffix;
        String localised = iChunUtil.eC().getLocalisedString(key, new Object[0]);
        if (localised.equals(key)) {
            if (DEFAULT_CATEGORY_COMMENTS.containsKey(category.name)) {
                return iChunUtil.eC().getLocalisedString("config.ichunutil.cat." + category.name + suffix, new Object[0]);
            }
            if (comment) {
                if (category.comment != null) {
                    return category.comment;
                }
                return null;
            }
            return category.name;
        }
        return localised;
    }

    @Nullable
    @Environment(value=EnvType.CLIENT)
    public String getLocalisedName(Category.Entry entry, boolean comment) {
        String suffix = comment ? ".desc" : ".name";
        String key = comment ? entry.commentKey : "config." + this.getModId() + ".prop." + entry.field.getName() + suffix;
        String localised = iChunUtil.eC().getLocalisedString(key, new Object[0]);
        if (localised.equals(key)) {
            if (comment) {
                if (entry.comment != null) {
                    return entry.comment;
                }
                return null;
            }
            return entry.field.getName();
        }
        return localised;
    }

    @Override
    public int compareTo(ConfigBase o) {
        if (this.getConfigName().equals(o.getConfigName())) {
            return Integer.compare(this.getConfigType().ordinal(), o.getConfigType().ordinal());
        }
        return this.getConfigName().toLowerCase(Locale.ROOT).compareTo(o.getConfigName().toLowerCase(Locale.ROOT));
    }

    private static boolean isValidField(Field field) {
        return !Modifier.isTransient(field.getModifiers()) && !Modifier.isStatic(field.getModifiers()) && (field.getType() == Integer.TYPE || field.getType() == Double.TYPE || field.getType() == Boolean.TYPE || field.getType() == String.class || field.getType().isEnum() || List.class.isAssignableFrom(field.getType()) || field.getType() == KeyBind.class);
    }

    public static enum Type {
        CLIENT,
        COMMON,
        SERVER;

    }

    public static class Category
    implements Comparable<Category> {
        @NotNull
        public final String name;
        @Nullable
        public final String comment;
        @NotNull
        public final String commentKey;
        public final boolean showInGui;
        private final LinkedHashSet<Entry> entries = new LinkedHashSet();

        public Category(@NotNull String name, @Nullable String comment, @NotNull String commentKey, boolean showInGui) {
            this.name = name;
            this.comment = comment;
            this.commentKey = commentKey;
            this.showInGui = showInGui;
        }

        public void addField(Field f, Prop props, String comment, String commentKey, Object defaultValue) {
            this.entries.add(new Entry(f, props, comment, commentKey, defaultValue));
        }

        public LinkedHashSet<Entry> getEntries() {
            return this.entries;
        }

        @Override
        public int compareTo(@NotNull Category o) {
            return this.name.compareTo(o.name);
        }

        public static class Entry
        implements Comparable<Entry> {
            @NotNull
            public final Field field;
            @NotNull
            public final Prop prop;
            @Nullable
            public final String comment;
            @NotNull
            public final String commentKey;
            @NotNull
            public final Object defaultValue;

            public Entry(@NotNull Field field, @NotNull Prop prop, @Nullable String comment, @NotNull String commentKey, @NotNull Object defaultValue) {
                this.field = field;
                this.prop = prop;
                this.comment = comment;
                this.commentKey = commentKey;
                this.defaultValue = defaultValue;
            }

            @Override
            public int compareTo(@NotNull Entry o) {
                return this.field.getName().compareTo(o.field.getName());
            }
        }
    }

    public static enum FilterType {
        ALLOW,
        DENY;

    }
}

