/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.serverpause.common.core;

import com.mojang.brigadier.CommandDispatcher;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.ichun.mods.ichunutil.common.entity.EntityHelper;
import me.ichun.mods.ichunutil.common.iChunUtil;
import me.ichun.mods.ichunutil.common.network.AbstractPacket;
import me.ichun.mods.serverpause.common.ServerPause;
import me.ichun.mods.serverpause.common.core.PauseCommand;
import me.ichun.mods.serverpause.common.network.packet.PacketServerPause;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.server.MinecraftServer;

public class EventHandlerServer {
    public HashMap<UUID, Boolean> pauseState = new HashMap();
    public boolean isPaused;
    public boolean serverPaused;
    public boolean forcePause;
    public boolean wasForcePaused;

    public EventHandlerServer() {
        iChunUtil.eS().registerPlayerLoggedInListener(this::onPlayerLogin);
        iChunUtil.eS().registerPlayerLoggedOutListener(this::onPlayerLogout);
        iChunUtil.eS().registerServerAboutToStartListener(server -> this.resetServer((MinecraftServer)server, true));
        iChunUtil.eS().registerServerStoppingListener(server -> this.resetServer((MinecraftServer)server, false));
        iChunUtil.eS().registerCommandRegistrationListener(this::registerPauseCommand);
    }

    public void onPlayerLogin(class_3222 player) {
        if (EntityHelper.isFakePlayer((class_3222)player)) {
            return;
        }
        this.pauseState.put(player.method_7334().getId(), false);
        this.checkAndUpdatePauseState();
        if ((ServerPause.modProxy.getServer().method_3816() || this.pauseState.size() != 1) && ServerPause.config.sendChatMessageWhenPlayerPauseStateChanges) {
            int pauseCount = 0;
            for (Map.Entry<UUID, Boolean> e : this.pauseState.entrySet()) {
                if (!e.getValue().booleanValue()) continue;
                ++pauseCount;
            }
            if (pauseCount > 0) {
                String prefix = pauseCount + "/" + this.pauseState.size();
                class_5250 chat = class_2561.method_43469((String)"serverpause.message.playersPaused", (Object[])new Object[]{prefix});
                player.method_43496((class_2561)chat);
            }
        }
        if (this.isPaused) {
            ServerPause.channel.sendTo((AbstractPacket)new PacketServerPause(true), player);
            if ((ServerPause.modProxy.getServer().method_3816() || this.pauseState.size() != 1) && (this.forcePause || this.wasForcePaused || ServerPause.config.sendChatMessageWhenPauseStateChanges)) {
                player.method_43496((class_2561)class_2561.method_43471((String)"serverpause.message.paused"));
            }
        }
    }

    public void onPlayerLogout(class_3222 player) {
        this.pauseState.remove(player.method_7334().getId());
        this.checkAndUpdatePauseState();
    }

    public void updatePlayerState(class_1657 player, boolean paused) {
        Boolean wasPaused = this.pauseState.put(player.method_7334().getId(), paused);
        if (ServerPause.modProxy.getServer() != null && (ServerPause.modProxy.getServer().method_3816() || this.pauseState.size() != 1) && ServerPause.config.sendChatMessageWhenPlayerPauseStateChanges && (wasPaused == null || wasPaused != paused)) {
            String playerName = player.method_7334().getName();
            int pauseCount = 0;
            for (Map.Entry<UUID, Boolean> e : this.pauseState.entrySet()) {
                if (!e.getValue().booleanValue()) continue;
                ++pauseCount;
            }
            String prefix = "(" + pauseCount + "/" + this.pauseState.size() + ") ";
            ServerPause.modProxy.getServer().method_43496((class_2561)class_2561.method_43470((String)(paused ? prefix + playerName + " paused." : prefix + playerName + " unpaused.")));
            class_5250 chat = class_2561.method_43469((String)(paused ? "serverpause.message.playerPaused" : "serverpause.message.playerUnpaused"), (Object[])new Object[]{prefix + playerName});
            for (class_3222 player1 : ServerPause.modProxy.getServer().method_3760().method_14571()) {
                player1.method_43496((class_2561)chat);
            }
        }
        this.checkAndUpdatePauseState();
    }

    public void registerPauseCommand(CommandDispatcher<class_2168> dispatcher) {
        PauseCommand.register(dispatcher);
    }

    public void toggleForcePause() {
        this.wasForcePaused = this.forcePause;
        this.forcePause = !this.forcePause;
        this.checkAndUpdatePauseState();
    }

    public void checkAndUpdatePauseState() {
        boolean shouldPause = ServerPause.config.pauseWhenAllPlayersPaused;
        if (this.pauseState.isEmpty()) {
            shouldPause = (this.forcePause || ServerPause.config.pauseWhenNoPlayers) && ServerPause.modProxy.getServer() != null && ServerPause.modProxy.getServer().method_3816();
        } else if (!this.forcePause && ServerPause.config.pauseWhenAllPlayersPaused) {
            for (Map.Entry<UUID, Boolean> e : this.pauseState.entrySet()) {
                if (e.getValue().booleanValue()) continue;
                shouldPause = false;
                break;
            }
        }
        if (this.isPaused != shouldPause && ServerPause.modProxy.getServer() != null) {
            this.isPaused = shouldPause;
            ServerPause.channel.sendToAll((AbstractPacket)new PacketServerPause(this.isPaused));
            if ((ServerPause.modProxy.getServer().method_3816() || this.pauseState.size() != 1) && (this.forcePause || this.wasForcePaused || ServerPause.config.sendChatMessageWhenPauseStateChanges)) {
                ServerPause.modProxy.getServer().method_43496((class_2561)class_2561.method_43470((String)(this.isPaused ? "Server paused." : "Server unpaused.")));
                class_5250 chat = class_2561.method_43471((String)(this.isPaused ? "serverpause.message.paused" : "serverpause.message.unpaused"));
                for (class_3222 player : ServerPause.modProxy.getServer().method_3760().method_14571()) {
                    player.method_43496((class_2561)chat);
                }
            }
        }
        this.wasForcePaused = false;
    }

    public void resetServer(MinecraftServer server, boolean starting) {
        this.pauseState.clear();
        this.isPaused = starting && ServerPause.config.pauseWhenNoPlayers && server.method_3816();
        this.serverPaused = false;
        this.wasForcePaused = false;
        this.forcePause = false;
    }
}

