/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.serverpause.compat;

import com.mojang.logging.LogUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import me.ichun.mods.serverpause.common.ServerPause;
import net.minecraft.class_156;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;

public final class CompatHandler {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final HashMap<String, Class<?>> REGISTERED_COMPATS = (HashMap)class_156.method_654(new HashMap(), m -> m.put("valkyrienSkies", CompatValkyrienSkies.class));
    private static HashSet<Compat> compats;

    public static void tickServer(MinecraftServer server, boolean isPaused) {
        if (compats == null) {
            compats = new HashSet();
            CompatHandler.checkCompats();
        }
        compats.removeIf(c -> !c.tickServer(server, isPaused));
    }

    private static void checkCompats() {
        REGISTERED_COMPATS.forEach((k, v) -> {
            if (!ServerPause.config.disabledCompatibilities.contains(k)) {
                try {
                    Compat compat = (Compat)v.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    if (compat.check()) {
                        compats.add(compat);
                    }
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    LOGGER.error("Error creating compat class: {}", (Object)v.getName(), (Object)e);
                }
            }
        });
    }

    private static abstract class Compat {
        private Compat() {
        }

        abstract boolean check();

        abstract boolean tickServer(MinecraftServer var1, boolean var2);
    }

    private static class CompatValkyrienSkies
    extends Compat {
        Method getVsPipeline;
        Method setArePhysicsRunning;

        private CompatValkyrienSkies() {
        }

        @Override
        boolean check() {
            try {
                Class<?> clzProvider = Class.forName("org.valkyrienskies.mod.common.IShipObjectWorldServerProvider");
                Class<?> clzPipeline = Class.forName("org.valkyrienskies.core.apigame.world.VSPipeline");
                LOGGER.info("Found ValkyrienSkies classes, looking for methods");
                this.getVsPipeline = clzProvider.getDeclaredMethod("getVsPipeline", new Class[0]);
                this.getVsPipeline.setAccessible(true);
                this.setArePhysicsRunning = clzPipeline.getDeclaredMethod("setArePhysicsRunning", Boolean.TYPE);
                this.setArePhysicsRunning.setAccessible(true);
                LOGGER.info("Found ValkyrienSkies methods! All ok!");
                return true;
            }
            catch (ClassNotFoundException clzProvider) {
            }
            catch (NoSuchMethodException e) {
                LOGGER.error("Error getting a method!", (Throwable)e);
            }
            return false;
        }

        @Override
        boolean tickServer(MinecraftServer server, boolean isPaused) {
            if (server.method_3816()) {
                try {
                    Object pipeline = this.getVsPipeline.invoke((Object)server, new Object[0]);
                    if (pipeline != null) {
                        this.setArePhysicsRunning.invoke(pipeline, !isPaused);
                    }
                    return true;
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    LOGGER.error("Error ticking for ValkyrienSkies compatibility", (Throwable)e);
                    return false;
                }
            }
            return true;
        }
    }
}

