/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.offline;

import com.mojang.datafixers.DataFixer;
import io.wispforest.owo.Owo;
import io.wispforest.owo.offline.DataSavedEvents;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.class_156;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_2512;
import net.minecraft.class_3551;
import net.minecraft.class_4284;
import net.minecraft.class_5218;
import org.jetbrains.annotations.Nullable;

public final class OfflineDataLookup {
    private OfflineDataLookup() {
    }

    public static void put(UUID player, class_2487 nbt) {
        ((DataSavedEvents.PlayerData)DataSavedEvents.PLAYER_DATA.invoker()).onSaved(player, nbt);
        try {
            File savedPlayersPath = Owo.currentServer().method_27050(class_5218.field_24182).toFile();
            File file = File.createTempFile(player.toString() + "-", ".dat", savedPlayersPath);
            class_2507.method_30614((class_2487)nbt, (File)file);
            File newDataFile = new File(savedPlayersPath, player + ".dat");
            File oldDataFile = new File(savedPlayersPath, player + ".dat_old");
            class_156.method_27760((File)newDataFile, (File)file, (File)oldDataFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Nullable
    public static class_2487 get(UUID player) {
        try {
            Path savedPlayersPath = Owo.currentServer().method_27050(class_5218.field_24182);
            Path savedDataPath = savedPlayersPath.resolve(player.toString() + ".dat");
            class_2487 rawNbt = class_2507.method_30613((File)savedDataPath.toFile());
            int dataVersion = rawNbt.method_10573("DataVersion", 3) ? rawNbt.method_10550("DataVersion") : -1;
            return class_2512.method_10688((DataFixer)class_3551.method_15450(), (class_4284)class_4284.field_19213, (class_2487)rawNbt, (int)dataVersion);
        }
        catch (IOException e) {
            Owo.LOGGER.error("Couldn't get player data for offline player {}", (Object)player, (Object)e);
            return null;
        }
    }

    public static void edit(UUID player, Function<class_2487, class_2487> editor) {
        OfflineDataLookup.put(player, editor.apply(OfflineDataLookup.get(player)));
    }

    public static List<UUID> savedPlayers() {
        ArrayList<UUID> list = new ArrayList<UUID>();
        Path savedPlayersPath = Owo.currentServer().method_27050(class_5218.field_24182);
        if (!Files.isDirectory(savedPlayersPath, new LinkOption[0])) {
            return Collections.emptyList();
        }
        try {
            Iterator iterator = Files.list(savedPlayersPath).iterator();
            while (iterator.hasNext()) {
                Path savedPlayerFile = (Path)iterator.next();
                if (Files.isDirectory(savedPlayerFile, new LinkOption[0]) || !savedPlayerFile.toString().endsWith(".dat")) continue;
                try {
                    String filename = savedPlayerFile.getFileName().toString();
                    String uuidStr = filename.substring(0, filename.lastIndexOf(46));
                    UUID uuid = UUID.fromString(uuidStr);
                    list.add(uuid);
                }
                catch (IllegalArgumentException iae) {
                    Owo.LOGGER.error("Encountered invalid UUID in playerdata directory", (Throwable)iae);
                }
            }
        }
        catch (IOException e) {
            Owo.LOGGER.error("Couldn't list offline player UUIDs", (Throwable)e);
            throw new RuntimeException(e);
        }
        return list;
    }
}

