/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.ui.component;

import io.wispforest.owo.ui.component.BlockComponent;
import io.wispforest.owo.ui.component.BoxComponent;
import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.component.CheckboxComponent;
import io.wispforest.owo.ui.component.DiscreteSliderComponent;
import io.wispforest.owo.ui.component.DropdownComponent;
import io.wispforest.owo.ui.component.EntityComponent;
import io.wispforest.owo.ui.component.ItemComponent;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.component.SliderComponent;
import io.wispforest.owo.ui.component.SpriteComponent;
import io.wispforest.owo.ui.component.TextBoxComponent;
import io.wispforest.owo.ui.component.TextureComponent;
import io.wispforest.owo.ui.component.VanillaWidgetComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.Sizing;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_1058;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2343;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_4730;
import org.jetbrains.annotations.Nullable;

public class Components {
    public static ButtonComponent button(class_2561 message, Consumer<ButtonComponent> onPress) {
        return new ButtonComponent(message, onPress);
    }

    public static TextBoxComponent textBox(Sizing horizontalSizing) {
        return new TextBoxComponent(horizontalSizing);
    }

    public static TextBoxComponent textBox(Sizing horizontalSizing, String text) {
        TextBoxComponent textBox = new TextBoxComponent(horizontalSizing);
        textBox.text(text);
        return textBox;
    }

    public static <E extends class_1297> EntityComponent<E> entity(Sizing sizing, class_1299<E> type, @Nullable class_2487 nbt) {
        return new EntityComponent<E>(sizing, type, nbt);
    }

    public static <E extends class_1297> EntityComponent<E> entity(Sizing sizing, E entity) {
        return new EntityComponent<E>(sizing, entity);
    }

    public static ItemComponent item(class_1799 item) {
        return new ItemComponent(item);
    }

    public static BlockComponent block(class_2680 state) {
        return new BlockComponent(state, null);
    }

    public static BlockComponent block(class_2680 state, class_2586 blockEntity) {
        return new BlockComponent(state, blockEntity);
    }

    public static BlockComponent block(class_2680 state, @Nullable class_2487 nbt) {
        class_310 client = class_310.method_1551();
        class_2586 blockEntity = null;
        class_2248 class_22482 = state.method_26204();
        if (class_22482 instanceof class_2343) {
            class_2343 provider = (class_2343)class_22482;
            blockEntity = provider.method_10123(client.field_1724.method_24515(), state);
            BlockComponent.prepareBlockEntity(state, blockEntity, nbt);
        }
        return new BlockComponent(state, blockEntity);
    }

    public static LabelComponent label(class_2561 text) {
        return new LabelComponent(text);
    }

    public static CheckboxComponent checkbox(class_2561 message) {
        return new CheckboxComponent(message);
    }

    public static SliderComponent slider(Sizing horizontalSizing) {
        return new SliderComponent(horizontalSizing);
    }

    public static DiscreteSliderComponent discreteSlider(Sizing horizontalSizing, double min, double max) {
        return new DiscreteSliderComponent(horizontalSizing, min, max);
    }

    public static SpriteComponent sprite(class_4730 spriteId) {
        return new SpriteComponent(spriteId.method_24148());
    }

    public static SpriteComponent sprite(class_1058 sprite) {
        return new SpriteComponent(sprite);
    }

    public static TextureComponent texture(class_2960 texture, int u, int v, int regionWidth, int regionHeight, int textureWidth, int textureHeight) {
        return new TextureComponent(texture, u, v, regionWidth, regionHeight, textureWidth, textureHeight);
    }

    public static TextureComponent texture(class_2960 texture, int u, int v, int regionWidth, int regionHeight) {
        return new TextureComponent(texture, u, v, regionWidth, regionHeight, 256, 256);
    }

    public static BoxComponent box(Sizing horizontalSizing, Sizing verticalSizing) {
        return new BoxComponent(horizontalSizing, verticalSizing);
    }

    public static DropdownComponent dropdown(Sizing horizontalSizing) {
        return new DropdownComponent(horizontalSizing);
    }

    public static <T, C extends Component> FlowLayout list(List<T> data, Consumer<FlowLayout> layoutConfigurator, Function<T, C> componentMaker, boolean vertical) {
        FlowLayout layout = vertical ? Containers.verticalFlow(Sizing.content(), Sizing.content()) : Containers.horizontalFlow(Sizing.content(), Sizing.content());
        layoutConfigurator.accept(layout);
        for (T value : data) {
            layout.child((Component)componentMaker.apply(value));
        }
        return layout;
    }

    public static VanillaWidgetComponent wrapVanillaWidget(class_339 widget) {
        return new VanillaWidgetComponent(widget);
    }

    public static <T extends Component> T createWithSizing(Supplier<T> componentMaker, Sizing horizontalSizing, Sizing verticalSizing) {
        Component component = (Component)componentMaker.get();
        component.sizing(horizontalSizing, verticalSizing);
        return (T)component;
    }
}

