/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.ui.container;

import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.Size;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.VerticalAlignment;
import io.wispforest.owo.ui.util.MountingHelper;
import java.util.ArrayList;
import org.apache.commons.lang3.mutable.MutableInt;

public class HorizontalFlowLayout
extends FlowLayout {
    protected HorizontalFlowLayout(Sizing horizontalSizing, Sizing verticalSizing) {
        super(horizontalSizing, verticalSizing);
    }

    @Override
    public void layout(Size space) {
        MutableInt layoutWidth = new MutableInt(0);
        MutableInt layoutHeight = new MutableInt(0);
        ArrayList layout = new ArrayList();
        Insets padding = (Insets)this.padding.get();
        Size childSpace = this.calculateChildSpace(space);
        MountingHelper mountState = MountingHelper.mountEarly((x$0, x$1, x$2) -> this.mountChild(x$0, x$1, x$2), this.children, childSpace, child -> {
            layout.add(child);
            child.inflate(childSpace);
            child.mount(this, this.x + padding.left() + ((Insets)child.margins().get()).left() + layoutWidth.intValue(), this.y + padding.top() + ((Insets)child.margins().get()).top());
            Size childSize = child.fullSize();
            layoutWidth.add(childSize.width() + this.gap);
            if (childSize.height() > layoutHeight.intValue()) {
                layoutHeight.setValue(childSize.height());
            }
        });
        layoutWidth.subtract(this.gap);
        this.contentSize = Size.of(layoutWidth.intValue(), layoutHeight.intValue());
        this.applySizing();
        if (this.verticalAlignment() != VerticalAlignment.TOP) {
            for (Component component : layout) {
                component.updateY(component.y() + this.verticalAlignment().align(component.fullSize().height(), this.height - padding.vertical()));
            }
        }
        if (this.horizontalAlignment() != HorizontalAlignment.LEFT) {
            for (Component component : layout) {
                if (this.horizontalAlignment() == HorizontalAlignment.CENTER) {
                    component.updateX(component.x() + (this.width - padding.horizontal() - layoutWidth.intValue()) / 2);
                    continue;
                }
                component.updateX(component.x() + (this.width - padding.horizontal() - layoutWidth.intValue()));
            }
        }
        mountState.mountLate();
    }
}

