/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.ui.core;

import com.google.common.collect.ImmutableMap;
import io.wispforest.owo.ui.core.Animatable;
import io.wispforest.owo.ui.parsing.UIModelParsingException;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.class_124;
import net.minecraft.class_1767;
import net.minecraft.class_3532;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Node;

public record Color(float red, float green, float blue, float alpha) implements Animatable<Color>
{
    public static final Color BLACK = Color.ofRgb(0);
    public static final Color WHITE = Color.ofRgb(0xFFFFFF);
    public static final Color RED = Color.ofRgb(0xFF0000);
    public static final Color GREEN = Color.ofRgb(65280);
    public static final Color BLUE = Color.ofRgb(255);
    private static final Map<String, Color> NAMED_TEXT_COLORS = (Map)Stream.of(class_124.values()).filter(class_124::method_543).collect(ImmutableMap.toImmutableMap(formatting -> formatting.method_537().toLowerCase(Locale.ROOT).replace("_", "-"), Color::ofFormatting));

    public Color(float red, float green, float blue) {
        this(red, green, blue, 1.0f);
    }

    public static Color ofArgb(int argb) {
        return new Color((float)(argb >> 16 & 0xFF) / 255.0f, (float)(argb >> 8 & 0xFF) / 255.0f, (float)(argb & 0xFF) / 255.0f, (float)(argb >>> 24) / 255.0f);
    }

    public static Color ofRgb(int rgb) {
        return new Color((float)(rgb >> 16 & 0xFF) / 255.0f, (float)(rgb >> 8 & 0xFF) / 255.0f, (float)(rgb & 0xFF) / 255.0f, 1.0f);
    }

    public static Color ofHsv(float hue, float saturation, float value) {
        return Color.ofRgb(class_3532.method_15369((float)hue, (float)saturation, (float)value));
    }

    public static Color ofFormatting(@NotNull class_124 formatting) {
        Integer colorValue = formatting.method_532();
        return Color.ofRgb(colorValue == null ? 0 : colorValue);
    }

    public static Color ofDye(@NotNull class_1767 dyeColor) {
        float[] components = dyeColor.method_7787();
        return new Color(components[0], components[1], components[2]);
    }

    public int rgb() {
        return (int)(this.red * 255.0f) << 16 | (int)(this.green * 255.0f) << 8 | (int)(this.blue * 255.0f);
    }

    public int argb() {
        return (int)(this.alpha * 255.0f) << 24 | (int)(this.red * 255.0f) << 16 | (int)(this.green * 255.0f) << 8 | (int)(this.blue * 255.0f);
    }

    public String asHexString(boolean includeAlpha) {
        return includeAlpha ? String.format("#%08X", this.argb()) : String.format("#%06X", this.rgb());
    }

    @Override
    public Color interpolate(Color next, float delta) {
        return new Color(class_3532.method_16439((float)delta, (float)this.red, (float)next.red), class_3532.method_16439((float)delta, (float)this.green, (float)next.green), class_3532.method_16439((float)delta, (float)this.blue, (float)next.blue), class_3532.method_16439((float)delta, (float)this.alpha, (float)next.alpha));
    }

    public static Color parse(Node node) {
        String text = node.getTextContent().strip();
        if (!text.startsWith("#")) {
            Color color = NAMED_TEXT_COLORS.get(text);
            if (color != null) {
                return color;
            }
            throw new UIModelParsingException("Invalid color value '" + text + "', expected hex color of format #RRGGBB or #AARRGGBB or named text color");
        }
        if (text.matches("#([A-Fa-f\\d]{2}){3,4}")) {
            return text.length() == 7 ? Color.ofRgb(Integer.parseUnsignedInt(text.substring(1), 16)) : Color.ofArgb(Integer.parseUnsignedInt(text.substring(1), 16));
        }
        throw new UIModelParsingException("Invalid color value '" + text + "', expected hex color of format #RRGGBB or #AARRGGBB or named text color");
    }

    public static int parseAndPack(Node node) {
        return Color.parse(node).argb();
    }
}

