/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.betterrespawn;

import de.maxhenkel.betterrespawn.BetterRespawnMod;
import de.maxhenkel.betterrespawn.RespawnAbilities;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.class_1656;
import net.minecraft.class_1657;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_5322;

public class RespawnManager {
    private static final int FIND_SPAWN_ATTEMPTS = 16;
    private final Random random = new Random();

    public void onPlayerDeath(class_3222 player) {
        Optional respawnVector;
        class_1656 class_16562 = player.method_31549();
        if (!(class_16562 instanceof RespawnAbilities)) {
            return;
        }
        RespawnAbilities respawnAbilities = (RespawnAbilities)class_16562;
        respawnAbilities.setRespawnDimension((class_5321<class_1937>)player.method_26281());
        respawnAbilities.setRespawnPos(player.method_26280());
        respawnAbilities.setRespawnAngle(player.method_30631());
        respawnAbilities.setRespawnForced(player.method_26282());
        class_3218 respawnDimension = player.method_5682().method_3847(player.method_26281());
        class_2338 respawnLocation = player.method_26280();
        float respawnAngle = player.method_30631();
        if (respawnLocation != null && (respawnVector = class_1657.method_26091((class_3218)(respawnDimension == null ? player.method_14220() : respawnDimension), (class_2338)respawnLocation, (float)respawnAngle, (boolean)false, (boolean)true)).isPresent()) {
            class_243 spawn = (class_243)respawnVector.get();
            if (respawnDimension == player.method_14220() && player.method_24515().method_19455(new class_2382(spawn.field_1352, spawn.field_1351, spawn.field_1350)) <= BetterRespawnMod.SERVER_CONFIG.respawnBlockRange.get()) {
                BetterRespawnMod.LOGGER.info("Player {} is within the range of its respawn block", (Object)player.method_5477().getString());
                return;
            }
        }
        if (player.method_14220().method_8597().comp_643() || !player.method_14220().method_8597().comp_648()) {
            BetterRespawnMod.LOGGER.info("Can't respawn {} in {}", (Object)player.method_5477().getString(), (Object)player.method_14220().method_27983().method_29177());
            return;
        }
        class_2338 respawnPos = this.findValidRespawnLocation(player.method_14220(), player.method_24515());
        if (respawnPos == null) {
            return;
        }
        player.method_26284(player.field_6002.method_27983(), respawnPos, 0.0f, true, true);
        BetterRespawnMod.LOGGER.info("Set temporary respawn location to [{}, {}, {}]", (Object)respawnPos.method_10263(), (Object)respawnPos.method_10264(), (Object)respawnPos.method_10260());
    }

    public void onSetRespawnPosition(class_3222 player, class_5321<class_1937> dimension, @Nullable class_2338 pos, float angle, boolean forced, boolean showMessage) {
        if (forced) {
            return;
        }
        class_1656 class_16562 = player.method_31549();
        if (!(class_16562 instanceof RespawnAbilities)) {
            return;
        }
        RespawnAbilities abilities = (RespawnAbilities)class_16562;
        if (pos == null) {
            dimension = class_1937.field_25179;
        }
        abilities.setRespawnDimension((class_5321<class_1937>)dimension);
        abilities.setRespawnPos(pos);
        abilities.setRespawnAngle(angle);
        abilities.setRespawnForced(forced);
        if (pos != null) {
            BetterRespawnMod.LOGGER.info("Updating the respawn location of player {} to [{}, {}, {}] in {}", (Object)player.method_5477().getString(), (Object)pos.method_10263(), (Object)pos.method_10264(), (Object)pos.method_10260(), (Object)dimension.method_29177());
        } else {
            BetterRespawnMod.LOGGER.info("Updating the respawn location of player {} to [NONE]", (Object)player.method_5477().getString());
        }
    }

    @Nullable
    public class_2338 findValidRespawnLocation(class_3218 world, class_2338 deathLocation) {
        int min = BetterRespawnMod.SERVER_CONFIG.minRespawnDistance.get();
        int max = BetterRespawnMod.SERVER_CONFIG.maxRespawnDistance.get();
        class_2338 pos = null;
        for (int i = 0; i < 16 && pos == null; ++i) {
            BetterRespawnMod.LOGGER.info("Searching for respawn location - Attempt {}/{}", (Object)(i + 1), (Object)16);
            pos = class_5322.method_29196((class_3218)world, (class_1923)new class_1923(new class_2338(this.getRandomRange(deathLocation.method_10263(), min, max), 0, this.getRandomRange(deathLocation.method_10260(), min, max))));
            if (pos == null || world.method_8621().method_11952(pos)) continue;
            pos = null;
        }
        if (pos == null) {
            BetterRespawnMod.LOGGER.info("Found no valid respawn location after {} attempts", (Object)16);
        } else {
            BetterRespawnMod.LOGGER.info("Found valid respawn location: [{}, {}, {}]", (Object)pos.method_10263(), (Object)pos.method_10264(), (Object)pos.method_10260());
        }
        return pos;
    }

    private int getRandomRange(int actual, int minDistance, int maxDistance) {
        return actual + (this.random.nextBoolean() ? -1 : 1) * (minDistance + this.random.nextInt(maxDistance - minDistance));
    }
}

