/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.betterrespawn.configbuilder;

import de.maxhenkel.betterrespawn.configbuilder.CommentedPropertyConfig;
import de.maxhenkel.betterrespawn.configbuilder.Config;
import de.maxhenkel.betterrespawn.configbuilder.ConfigBuilder;
import de.maxhenkel.betterrespawn.configbuilder.ConfigEntry;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class ConfigBuilderImpl
implements ConfigBuilder {
    protected CommentedPropertyConfig config;
    protected List<ConfigEntryImpl<?>> entries;

    private ConfigBuilderImpl(CommentedPropertyConfig config) {
        this.config = config;
        this.entries = new ArrayList();
    }

    static ConfigBuilderImpl buildInternal(Path path) {
        return new ConfigBuilderImpl(new CommentedPropertyConfig(path));
    }

    void removeUnused() {
        List existingKeys = this.entries.stream().map(configEntry -> configEntry.key).collect(Collectors.toList());
        List toRemove = this.config.getProperties().keySet().stream().filter(s -> !existingKeys.contains(s)).collect(Collectors.toList());
        for (String key : toRemove) {
            this.config.getProperties().remove(key);
        }
    }

    void sortEntries() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (int i = 0; i < this.entries.size(); ++i) {
            map.put(this.entries.get((int)i).key, i);
        }
        this.config.getProperties().sort(Comparator.comparingInt(o -> map.getOrDefault(o, Integer.MAX_VALUE)));
    }

    void reloadFromDisk() {
        this.config.reload();
        this.entries.forEach(ConfigEntryImpl::loadOrDefault);
    }

    @Override
    public ConfigBuilderImpl header(String ... header) {
        this.config.getProperties().setHeaderComments(Arrays.asList(header));
        return this;
    }

    @Override
    public ConfigEntry<Boolean> booleanEntry(String key, boolean def, String ... comments) {
        BooleanConfigEntry entry = new BooleanConfigEntry(this.config);
        entry.comments = comments;
        entry.key = key;
        entry.def = def;
        entry.loadOrDefault();
        this.entries.add(entry);
        return entry;
    }

    @Override
    public ConfigEntry<Integer> integerEntry(String key, int def, int min, int max, String ... comments) {
        IntegerConfigEntry entry = new IntegerConfigEntry(this.config, min, max);
        entry.comments = comments;
        entry.key = key;
        entry.def = def;
        entry.loadOrDefault();
        this.entries.add(entry);
        return entry;
    }

    @Override
    public ConfigEntry<Double> doubleEntry(String key, double def, double min, double max, String ... comments) {
        DoubleConfigEntry entry = new DoubleConfigEntry(this.config, min, max);
        entry.comments = comments;
        entry.key = key;
        entry.def = def;
        entry.loadOrDefault();
        this.entries.add(entry);
        return entry;
    }

    @Override
    public ConfigEntry<String> stringEntry(String key, String def, String ... comments) {
        StringConfigEntry entry = new StringConfigEntry(this.config);
        entry.comments = comments;
        entry.key = key;
        entry.def = def;
        entry.loadOrDefault();
        this.entries.add(entry);
        return entry;
    }

    @Override
    public ConfigEntry<List<Integer>> integerListEntry(String key, List<Integer> def, String ... comments) {
        IntegerListConfigEntry entry = new IntegerListConfigEntry(this.config);
        entry.comments = comments;
        entry.key = key;
        entry.def = def;
        entry.loadOrDefault();
        this.entries.add(entry);
        return entry;
    }

    public <T extends Enum<T>> ConfigEntry<T> enumEntry(String key, T def, String ... comments) {
        EnumConfigEntry entry = new EnumConfigEntry(this.config, def.getClass());
        entry.comments = comments;
        entry.key = key;
        entry.def = def;
        entry.loadOrDefault();
        this.entries.add(entry);
        return entry;
    }

    public static class IntegerListConfigEntry
    extends ConfigEntryImpl<List<Integer>> {
        private IntegerListConfigEntry(CommentedPropertyConfig config) {
            super(config);
        }

        @Override
        @Nullable
        public List<Integer> deserialize(String str) {
            String[] split;
            ArrayList<Integer> list = new ArrayList<Integer>();
            for (String n : split = str.split(",")) {
                try {
                    list.add(Integer.parseInt(n));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return list;
        }

        @Override
        public String serialize(List<Integer> val) {
            return val.stream().map(String::valueOf).collect(Collectors.joining(","));
        }
    }

    public static class EnumConfigEntry<T extends Enum>
    extends ConfigEntryImpl<Enum> {
        protected Class<T> enumClass;

        private EnumConfigEntry(CommentedPropertyConfig config, Class<T> enumClass) {
            super(config);
            this.enumClass = enumClass;
        }

        @Override
        @Nullable
        public Enum deserialize(String str) {
            try {
                return Enum.valueOf(this.enumClass, str);
            }
            catch (Exception e) {
                return null;
            }
        }

        @Override
        public String serialize(Enum val) {
            return val.name();
        }
    }

    public static class StringConfigEntry
    extends ConfigEntryImpl<String> {
        private StringConfigEntry(CommentedPropertyConfig config) {
            super(config);
        }

        @Override
        @Nullable
        public String deserialize(String str) {
            return str;
        }

        @Override
        public String serialize(String val) {
            return val;
        }
    }

    public static class DoubleConfigEntry
    extends ConfigEntryImpl<Double> {
        private final double min;
        private final double max;

        private DoubleConfigEntry(CommentedPropertyConfig config, double min, double max) {
            super(config);
            this.min = min;
            this.max = max;
        }

        @Override
        @Nullable
        public Double deserialize(String str) {
            try {
                return Double.parseDouble(str);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }

        public double getMin() {
            return this.min;
        }

        public double getMax() {
            return this.max;
        }

        @Override
        protected Double fixValue(Double value) {
            return Math.max(Math.min(value, this.max), this.min);
        }

        @Override
        public String serialize(Double val) {
            return String.valueOf(val);
        }
    }

    public static class IntegerConfigEntry
    extends ConfigEntryImpl<Integer> {
        private final int min;
        private final int max;

        private IntegerConfigEntry(CommentedPropertyConfig config, int min, int max) {
            super(config);
            this.min = min;
            this.max = max;
        }

        @Override
        @Nullable
        public Integer deserialize(String str) {
            try {
                return Integer.parseInt(str);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }

        public int getMin() {
            return this.min;
        }

        public int getMax() {
            return this.max;
        }

        @Override
        protected Integer fixValue(Integer value) {
            return Math.max(Math.min(value, this.max), this.min);
        }

        @Override
        public String serialize(Integer val) {
            return String.valueOf(val);
        }
    }

    public static class BooleanConfigEntry
    extends ConfigEntryImpl<Boolean> {
        private BooleanConfigEntry(CommentedPropertyConfig config) {
            super(config);
        }

        @Override
        @Nullable
        public Boolean deserialize(String str) {
            return Boolean.valueOf(str);
        }

        @Override
        public String serialize(Boolean val) {
            return String.valueOf(val);
        }
    }

    public static abstract class ConfigEntryImpl<T>
    implements ConfigEntry<T> {
        protected CommentedPropertyConfig config;
        protected String[] comments;
        protected String key;
        protected T value;
        protected T def;

        private ConfigEntryImpl(CommentedPropertyConfig config) {
            this.config = config;
        }

        @Override
        public T get() {
            return this.value;
        }

        @Override
        public ConfigEntryImpl<T> set(T value) {
            if (this.value.equals(value)) {
                return this;
            }
            this.value = this.fixValue(value);
            String serialized = this.serialize(this.value);
            this.config.getProperties().set(this.key, serialized, this.comments);
            return this;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public ConfigEntryImpl<T> comment(String ... comments) {
            this.comments = comments;
            this.config.getProperties().setComments(this.key, Arrays.asList(comments));
            return this;
        }

        @Override
        public String[] getComments() {
            return this.comments;
        }

        protected void loadOrDefault() {
            if (this.config.getProperties().containsKey(this.key)) {
                T val = this.deserialize(this.config.getProperties().get(this.key));
                if (val == null) {
                    this.reset();
                } else {
                    this.value = this.fixValue(val);
                    this.config.properties.setComments(this.key, Arrays.asList(this.comments));
                }
            } else {
                this.reset();
            }
        }

        @Override
        public ConfigEntry<T> reset() {
            this.value = this.def;
            this.config.getProperties().set(this.key, this.serialize(this.def), this.comments);
            return this;
        }

        @Override
        public ConfigEntry<T> save() {
            this.config.save();
            return this;
        }

        @Override
        public ConfigEntry<T> saveSync() {
            this.config.saveSync();
            return this;
        }

        @Nullable
        public abstract T deserialize(String var1);

        public abstract String serialize(T var1);

        protected T fixValue(T value) {
            return value;
        }

        @Override
        public T getDefault() {
            return this.def;
        }

        @Override
        public Config getConfig() {
            return this.config;
        }
    }
}

