/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.installer;

import java.awt.GraphicsEnvironment;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.installer.Handler;
import net.fabricmc.installer.InstallerGui;
import net.fabricmc.installer.client.ClientHandler;
import net.fabricmc.installer.server.ServerHandler;
import net.fabricmc.installer.util.ArgumentParser;
import net.fabricmc.installer.util.CrashDialog;
import net.fabricmc.installer.util.FabricService;
import net.fabricmc.installer.util.MetaHandler;
import net.fabricmc.installer.util.OperatingSystem;

public class Main {
    public static MetaHandler GAME_VERSION_META;
    public static MetaHandler LOADER_META;
    public static final List<Handler> HANDLERS;

    public static void main(String[] args) throws IOException {
        if (OperatingSystem.CURRENT == OperatingSystem.WINDOWS) {
            System.setProperty("javax.net.ssl.trustStoreType", "WINDOWS-ROOT");
        }
        System.out.println("Loading Fabric Installer: " + Main.class.getPackage().getImplementationVersion());
        HANDLERS.add(new ClientHandler());
        HANDLERS.add(new ServerHandler());
        ArgumentParser argumentParser = ArgumentParser.create(args);
        String command = argumentParser.getCommand().orElse(null);
        String metaUrl = argumentParser.get("metaurl");
        String mavenUrl = argumentParser.get("mavenurl");
        if (metaUrl != null || mavenUrl != null) {
            FabricService.setFixed(metaUrl, mavenUrl);
        }
        GAME_VERSION_META = new MetaHandler("game", "v2/versions/game");
        LOADER_META = new MetaHandler("loader", "v2/versions/loader");
        if (GraphicsEnvironment.isHeadless() && command == null) {
            command = "help";
        }
        if (command == null) {
            try {
                InstallerGui.start();
            }
            catch (Exception e) {
                e.printStackTrace();
                new CrashDialog(e);
            }
        } else if (command.equals("help")) {
            System.out.println("help - Opens this menu");
            HANDLERS.forEach(handler -> System.out.printf("%s %s\n", handler.name().toLowerCase(), handler.cliHelp()));
            Main.loadMetadata();
            System.out.printf("\nLatest Version: %s\nLatest Loader: %s\n", GAME_VERSION_META.getLatestVersion(argumentParser.has("snapshot")).getVersion(), LOADER_META.getLatestVersion(false).getVersion());
        } else {
            Main.loadMetadata();
            for (Handler handler2 : HANDLERS) {
                if (!command.equalsIgnoreCase(handler2.name())) continue;
                try {
                    handler2.installCli(argumentParser);
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to install " + handler2.name(), e);
                }
                return;
            }
            System.out.println("No handler found for " + args[0] + " see help");
        }
    }

    public static void loadMetadata() {
        try {
            LOADER_META.load();
            GAME_VERSION_META.load();
        }
        catch (Throwable t) {
            throw new RuntimeException("Unable to load metadata", t);
        }
    }

    static {
        HANDLERS = new ArrayList<Handler>();
    }
}

