/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.installer.server;

import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import net.fabricmc.installer.util.LauncherMeta;
import net.fabricmc.installer.util.Utils;
import net.fabricmc.installer.util.VersionMeta;

public class MinecraftServerDownloader {
    private final String gameVersion;

    public MinecraftServerDownloader(String gameVersion) {
        this.gameVersion = gameVersion;
    }

    public void downloadMinecraftServer(Path serverJar) throws IOException {
        if (this.isServerJarValid(serverJar)) {
            System.out.println("Existing server jar valid, not downloading");
            return;
        }
        Path serverJarTmp = serverJar.resolveSibling(serverJar.getFileName().toString() + ".tmp");
        Files.deleteIfExists(serverJar);
        Utils.downloadFile(new URL(this.getServerDownload().url), serverJarTmp);
        if (!this.isServerJarValid(serverJarTmp)) {
            throw new IOException("Failed to validate downloaded server jar");
        }
        Files.move(serverJarTmp, serverJar, StandardCopyOption.REPLACE_EXISTING);
    }

    private boolean isServerJarValid(Path serverJar) throws IOException {
        if (!Files.exists(serverJar, new LinkOption[0])) {
            return false;
        }
        return Utils.sha1String(serverJar).equalsIgnoreCase(this.getServerDownload().sha1);
    }

    private VersionMeta getVersionMeta() throws IOException {
        LauncherMeta.Version version = LauncherMeta.getLauncherMeta().getVersion(this.gameVersion);
        if (version == null) {
            throw new RuntimeException("Failed to find version info for minecraft " + this.gameVersion);
        }
        return version.getVersionMeta();
    }

    private VersionMeta.Download getServerDownload() throws IOException {
        return this.getVersionMeta().downloads.get("server");
    }
}

