#!/usr/bin/env bash
PORT=25565
PID=$(lsof -ti tcp:$PORT)

if [[ -n "$PID" ]]; then
    echo "Port $PORT is in use by process ID(s): $PID"
    echo "Killing process..."
    kill -9 $PID
fi

echo "Launching Fabric server on port $PORT …"

exec java -Dio.netty.transport.noNative=true \
     -Xmx4G \
     -jar fabric-server-mc.1.19.2-loader.0.16.14-launcher.1.0.3.jar \
     nogui
