from omegaconf import DictConfig
from typing import Any, Dict, List

def get_evaluate_task_and_goal(cfg: DictConfig) -> List[str]:
    id_map = {task["id"]: task for task in cfg["all_task"]}
    evaluate_id = cfg["benchmark_evaluate_id"]

    task = id_map[evaluate_id]["instruction"]
    goal = id_map[evaluate_id]["goal"]

    return task, goal