import os
import glob


def remove_pt_files(root_dir="."):
    """Recursively removes all '*.pt' files in child directories."""
    for file_path in glob.iglob(os.path.join(root_dir, "**", "*.pt"), recursive=True):
        os.remove(file_path)
        print(f"Deleted: {file_path}")


if __name__ == "__main__":
    remove_pt_files()
