from abc import ABC, abstractmethod


class BasePlanningModel(ABC):
    """
    Base class for planning models.
    """
    @abstractmethod
    def decomposed_plan(self):
        """
        Perform the planning, but in a more decomposed way.
        This method should be implemented by subclasses.
        """
        raise NotImplementedError

    # @abstractmethod
    # def planning(self):
    #     """
    #     Perform the planning process.
    #     This method should be implemented by subclasses.
    #     """
    #     raise NotImplementedError
