_base_ = [
    '../datasets/custom_nus-3d.py',
    '../_base_/default_runtime.py'
]
#
plugin = True
plugin_dir = 'projects/mmdet3d_plugin/'

# If point cloud range is changed, the models should also change their point
# cloud range accordingly
# point_cloud_range = [-51.2, -51.2, -5.0, 51.2, 51.2, 3.0]
point_cloud_range = [-30.0, -15.0, -5.0, 30.0, 15.0, 3.0]
voxel_size = [0.15, 0.15, 8.0]
dbound = [1.0, 35.0, 0.5]

grid_config = {
    'x': [-30.0, -30.0, 0.15],  # useless
    'y': [-15.0, -15.0, 0.15],  # useless
    'z': [-10, 10, 20],        # useless
    'depth': [1.0, 35.0, 0.5],  # useful
}


img_norm_cfg = dict(
    mean=[123.675, 116.28, 103.53], std=[58.395, 57.12, 57.375], to_rgb=True)

# For nuScenes we usually do 10-class detection
class_names = [
    'car', 'truck', 'construction_vehicle', 'bus', 'trailer', 'barrier',
    'motorcycle', 'bicycle', 'pedestrian', 'traffic_cone'
]
# map has classes: divider, ped_crossing, boundary
map_classes = ['divider', 'boundary', 'ped_crossing']
# fixed_ptsnum_per_line = 20
# map_classes = ['divider',]
num_vec = 70
k_one2many = 5
fixed_ptsnum_per_gt_line = 20  # now only support fixed_pts > 0
fixed_ptsnum_per_pred_line = 20
eval_use_same_gt_sample_num_flag = True
num_map_classes = len(map_classes)

input_modality = dict(
    use_lidar=False,
    use_camera=True,
    use_radar=False,
    use_map=False,
    use_external=True)


_dim_ = 256
_pos_dim_ = _dim_//2
_ffn_dim_ = _dim_*2
_num_levels_ = 1
# bev_h_ = 50
# bev_w_ = 50
bev_h_ = 100
bev_w_ = 200
queue_length = 1  # each sequence contains `queue_length` frames.

aux_seg_cfg = dict(
    use_aux_seg=True,
    bev_seg=True,
    pv_seg=True,
    seg_classes=1,
    feat_down_sample=32,
    pv_thickness=1,
)

z_cfg = dict(
    pred_z_flag=False,
    gt_z_flag=False,
)

_osm_ptsnum_per_line_ = 10
_tag_enc_num_feats_ = 144
_osm_pos_enc_num_feats_ = 16
_graph_ident_dim_ = 64
if z_cfg['pred_z_flag']:
    _osm_input_dim_ = 3 * _osm_pos_enc_num_feats_ + _tag_enc_num_feats_ + 2*_graph_ident_dim_
else:
    _osm_input_dim_ = 3 * _osm_pos_enc_num_feats_ + _tag_enc_num_feats_ + 2*_graph_ident_dim_
_osm_enc_dim_ = _dim_

nlp_model_path="nlp_encoder_checkpoints/bert-144-osm-tags-embed-from_scratch/checkpoint-10628"

model = dict(
    type='M3TR',
    use_grid_mask=True,
    video_test_mode=False,
    pretrained=dict(img='ckpts/resnet50-19c8e357.pth'),
    img_backbone=dict(
        type='ResNet',
        depth=50,
        num_stages=4,
        out_indices=(3,),
        frozen_stages=1,
        norm_cfg=dict(type='BN', requires_grad=False),
        norm_eval=True,
        style='pytorch'),
    img_neck=dict(
        type='FPN',
        in_channels=[2048],
        out_channels=_dim_,
        start_level=0,
        add_extra_convs='on_output',
        num_outs=_num_levels_,
        relu_before_extra_convs=True),
    osm_map_encoder=dict(
        type='OSMMapEncoderPointLevel',
        input_dim=_osm_input_dim_,  
        dmodel=_osm_enc_dim_,     
        hidden_dim=_osm_enc_dim_, 
        orf_dim=_graph_ident_dim_,
        fixed_orf_order=True,
        nlp_model_path=nlp_model_path,
        nheads=4,
        nlayers=6,
        batch_first=True,
        nlp_pad_token=0,
        pos_encoder=dict(
            type='SineContinuousPositionalEncoding',
            num_feats=_osm_pos_enc_num_feats_,  # 2 * 16 = 32 final dim
            temp=1000,
            normalize=True,
            range=[point_cloud_range[3] - point_cloud_range[0], point_cloud_range[4] - point_cloud_range[1], point_cloud_range[5] - point_cloud_range[2]],
            offset=[point_cloud_range[0], point_cloud_range[1], point_cloud_range[2]],
        ),
    ),
    pts_bbox_head=dict(
        type='M3TRHead',
        bev_h=bev_h_,
        bev_w=bev_w_,
        num_query=900,
        num_vec_one2one=num_vec,
        num_vec_one2many=k_one2many*num_vec,
        k_one2many=k_one2many,
        num_pts_per_vec=fixed_ptsnum_per_pred_line,  # one bbox
        num_pts_per_gt_vec=fixed_ptsnum_per_gt_line,
        dir_interval=1,
        query_embed_type='instance_pts',
        use_masked_map_queries=True,
        mask_assign_gt_one2many=True,
        transform_method='minmax',
        gt_shift_pts_pattern='v2',
        num_classes=num_map_classes,
        in_channels=_dim_,
        sync_cls_avg_factor=True,
        with_box_refine=True,
        as_two_stage=False,
        code_size=3,
        code_weights=[1.0, 1.0, 1.0, 1.0],
        aux_seg=aux_seg_cfg,
        z_cfg=z_cfg,
        transformer=dict(
            type='MapTRPerceptionTransformer',
            num_cams=7,
            z_cfg=z_cfg,
            rotate_prev_bev=True,
            use_shift=True,
            use_can_bus=True,
            embed_dims=_dim_,
            encoder=dict(
                type='LSSTransform',
                in_channels=_dim_,
                out_channels=_dim_,
                feat_down_sample=32,
                pc_range=point_cloud_range,
                voxel_size=voxel_size,
                dbound=dbound,
                downsample=2,
                loss_depth_weight=3.0,
                depthnet_cfg=dict(use_dcn=False, with_cp=False,
                                  aspp_mid_channels=96),
                grid_config=grid_config,),
            decoder=dict(
                type='MapTRDecoder',
                num_layers=6,
                return_intermediate=True,
                transformerlayers=dict(
                    type='DecoupledDetrTransformerDecoderLayer',
                    num_vec=num_vec,
                    num_pts_per_vec=fixed_ptsnum_per_pred_line,
                    attn_cfgs=[
                        dict(
                            type='MultiheadAttention',
                            embed_dims=_dim_,
                            num_heads=8,
                            dropout=0.1),
                        dict(
                            type='MultiheadAttention',
                            embed_dims=_dim_,
                            num_heads=8,
                            dropout=0.1),
                        dict(
                           type='CustomMSDeformableAttention',
                           embed_dims=_dim_,
                           num_levels=1),
                        # dict(
                        #     type='CustomMSDeformableAttention',
                        #     embed_dims=_dim_,
                        #     num_levels=1),
                        dict(
                            type='MultiheadAttention',
                            embed_dims=_dim_,
                            num_heads=8,
                            dropout=0.1),
                    ],

                    feedforward_channels=_ffn_dim_,
                    ffn_dropout=0.1,
                    operation_order=('self_attn', 'norm', 'self_attn', 'norm', 'cross_attn', 'norm',
                                     'cross_attn', 'norm', 'ffn', 'norm')))),
        bbox_coder=dict(
            type='MapTRNMSFreeCoder',
            # post_center_range=[-61.2, -61.2, -10.0, 61.2, 61.2, 10.0],
            z_cfg=z_cfg,
            post_center_range=[-35, -20, -35, -20, 35, 20, 35, 20],
            pc_range=point_cloud_range,
            max_num=50,
            voxel_size=voxel_size,
            num_classes=num_map_classes),
        positional_encoding=dict(
            type='LearnedPositionalEncoding',
            num_feats=_pos_dim_,
            row_num_embed=bev_h_,
            col_num_embed=bev_w_,
        ),
        loss_cls=dict(
            type='FocalLoss',
            use_sigmoid=True,
            gamma=2.0,
            alpha=0.25,
            loss_weight=2.0),
        loss_bbox=dict(type='L1Loss', loss_weight=0.0),
        loss_iou=dict(type='GIoULoss', loss_weight=0.0),
        loss_pts=dict(type='PtsL1Loss',
                      loss_weight=5.0),
        loss_dir=dict(type='PtsDirCosLoss', loss_weight=0.005),
        loss_seg=dict(type='SimpleLoss',
                      pos_weight=4.0,
                      loss_weight=1.0),
        loss_pv_seg=dict(type='SimpleLoss',
                         pos_weight=1.0,
                         loss_weight=2.0),),
    # model training and testing settings
    train_cfg=dict(pts=dict(
        grid_size=[512, 512, 1],
        voxel_size=voxel_size,
        point_cloud_range=point_cloud_range,
        out_size_factor=4,
        assigner=dict(
            type='MapTRAssigner',
            z_cfg=z_cfg,
            cls_cost=dict(type='FocalLossCost', weight=2.0),
            reg_cost=dict(type='BBoxL1Cost', weight=0.0, box_format='xywh'),
            # reg_cost=dict(type='BBox3DL1Cost', weight=0.25),
            # iou_cost=dict(type='IoUCost', weight=1.0), # Fake cost. This is just to make it compatible with DETR head.
            iou_cost=dict(type='IoUCost', iou_mode='giou', weight=0.0),
            pts_cost=dict(type='OrderedPtsL1Cost',
                          weight=5),
            pc_range=point_cloud_range))),
    # We also need the assigner in test mode for map completion mode
    test_cfg=dict(pts=dict(
        grid_size=[512, 512, 1],
        voxel_size=voxel_size,
        point_cloud_range=point_cloud_range,
        out_size_factor=4,
        assigner=dict(
            type='MapTRAssigner',
            z_cfg=z_cfg,
            cls_cost=dict(type='FocalLossCost', weight=2.0),
            reg_cost=dict(type='BBoxL1Cost', weight=0.0, box_format='xywh'),
            # reg_cost=dict(type='BBox3DL1Cost', weight=0.25),
            # iou_cost=dict(type='IoUCost', weight=1.0), # Fake cost. This is just to make it compatible with DETR head.
            iou_cost=dict(type='IoUCost', iou_mode='giou', weight=0.0),
            pts_cost=dict(type='OrderedPtsL1Cost',
                          weight=5),
            pc_range=point_cloud_range))))

dataset_type = 'CustomAV2OfflineLocalMapDataset'
data_root = '/datasets/argoverse20/'

# ==============================================================================

# what type of split is trained on is specified by the labels pickle file
# ann_root = 'gen_labels/av2_maptracker_gt_with_osm_map/'
ann_root = 'gen_labels/av2_maptracker_gt_with_osm_map_streammapnet_split/'

#==============================================================================

file_client_args = dict(backend='disk')


train_pipeline = [
    dict(type='CustomLoadMultiViewImageFromFiles',
         to_float32=True, padding=True),
    dict(type='RandomScaleImageMultiViewImage', scales=[0.3]),
    dict(type='PhotoMetricDistortionMultiViewImage'),
    dict(type='NormalizeMultiviewImage', **img_norm_cfg),
    dict(type='PadMultiViewImage', size_divisor=32),
    dict(type='DefaultFormatBundle3D', with_gt=False,
         with_label=False, class_names=map_classes),
    dict(type='CustomCollect3D', keys=['img'])
]

test_pipeline = [
    dict(type='CustomLoadMultiViewImageFromFiles',
         to_float32=True, padding=True),
    dict(type='RandomScaleImageMultiViewImage', scales=[0.3]),
    dict(type='NormalizeMultiviewImage', **img_norm_cfg),

    dict(
        type='MultiScaleFlipAug3D',
        img_scale=(2048, 2048),  # 2048*0.3, 2048*0.3
        pts_scale_ratio=1,
        flip=False,
        transforms=[
            dict(type='PadMultiViewImage', size_divisor=32),
            dict(
                type='DefaultFormatBundle3D',
                with_gt=False,
                with_label=False,
                class_names=map_classes),
            dict(type='CustomCollect3D', keys=['img'])
        ])
]

data = dict(
    samples_per_gpu=8,
    workers_per_gpu=16,
    train=dict(
        type=dataset_type,
        data_root=data_root,
        ann_file=ann_root + 'av2_map_infos_train.pkl',
        z_cfg=z_cfg,
        pipeline=train_pipeline,
        classes=class_names,
        modality=input_modality,
        aux_seg=aux_seg_cfg,
        test_mode=False,
        use_valid_flag=True,
        bev_size=(bev_h_, bev_w_),
        pc_range=point_cloud_range,
        fixed_ptsnum_per_line=fixed_ptsnum_per_gt_line,
        fixed_ptsnum_per_line_osm=_osm_ptsnum_per_line_,
        eval_use_same_gt_sample_num_flag=eval_use_same_gt_sample_num_flag,
        padding_value=-10000,
        map_classes=map_classes,
        map_completion_mode=True,
        eval_only_masked_elements=True,
        nlp_model_path=nlp_model_path,
        queue_length=queue_length,
        # we use box_type_3d='LiDAR' in kitti and nuscenes dataset
        # and box_type_3d='Depth' in sunrgbd and scannet dataset.
        box_type_3d='LiDAR'),
    val=dict(
        type=dataset_type,
        data_root=data_root,
        ann_file=ann_root + 'av2_map_infos_val.pkl',
        map_ann_file=ann_root + 'av2_gt_map_anns_val_' + __name__ + '.json',
        # code_size=3,
        z_cfg=z_cfg,
        load_interval=4,  # av2 uses 10 Hz, set to 5, 2HZ the same as nuscenes,
        # load_interval=1, # TODO debug
        pipeline=test_pipeline,
        bev_size=(bev_h_, bev_w_),
        pc_range=point_cloud_range,
        fixed_ptsnum_per_line=fixed_ptsnum_per_gt_line,
        fixed_ptsnum_per_line_osm=_osm_ptsnum_per_line_,
        eval_use_same_gt_sample_num_flag=eval_use_same_gt_sample_num_flag,
        padding_value=-10000,
        map_classes=map_classes,
        map_completion_mode=True,
        eval_only_masked_elements=True,
        nlp_model_path=nlp_model_path,
        classes=class_names,
        modality=input_modality,
        samples_per_gpu=1),
    test=dict(
        type=dataset_type,
        data_root=data_root,
        ann_file=ann_root + 'av2_map_infos_val.pkl',
        map_ann_file=ann_root + 'av2_gt_map_anns_val_' + __name__ + '.json',
        # code_size=3,
        z_cfg=z_cfg,
        load_interval=4,  # av2 uses 10 Hz, set to 5, 2HZ the same as nuscenes,
        # load_interval=1, # TODO debug
        pipeline=test_pipeline,
        bev_size=(bev_h_, bev_w_),
        pc_range=point_cloud_range,
        fixed_ptsnum_per_line=fixed_ptsnum_per_gt_line,
        fixed_ptsnum_per_line_osm=_osm_ptsnum_per_line_,
        eval_use_same_gt_sample_num_flag=eval_use_same_gt_sample_num_flag,
        padding_value=-10000,
        map_classes=map_classes,
        map_completion_mode=True,
        eval_only_masked_elements=True,
        nlp_model_path=nlp_model_path,
        classes=class_names,
        modality=input_modality),
    shuffler_sampler=dict(type='DistributedGroupSampler'),
    nonshuffler_sampler=dict(type='DistributedSampler')
)

optimizer = dict(
    type='AdamW',
    lr=6e-4,
    paramwise_cfg=dict(
        custom_keys={
            'img_backbone': dict(lr_mult=0.1),
            'osm_map_encoder.nlp_model': dict(lr_mult=0.1)
        }),
    weight_decay=0.01)

# optimizer = dict(
#      type='AdamW',
#      lr=0.1*6e-4,
#      paramwise_cfg=dict(
#          custom_keys={
#              'osm_map_encoder.map_embedding': dict(lr_mult=10),
#              'osm_map_encoder.transformer_encoder': dict(lr_mult=10)
#          }),
#      weight_decay=0.01)

optimizer_config = dict(grad_clip=dict(max_norm=35, norm_type=2))
# learning policy
lr_config = dict(
    policy='CosineAnnealing',
    warmup='linear',
    warmup_iters=200,
    warmup_ratio=1.0 / 3,
    min_lr_ratio=1e-3)

total_epochs = 24
evaluation = dict(interval=1, pipeline=test_pipeline, metric='chamfer')

runner = dict(type='EpochBasedRunner', max_epochs=total_epochs)

# evaluation = dict(interval=200, pipeline=test_pipeline, metric='chamfer')
# runner = dict(type='IterBasedRunner', max_iters=1000)
checkpoint_config = dict(interval=1)

log_config = dict(
    interval=10,
    hooks=[
        dict(type='TextLoggerHook'),
        dict(type='TensorboardLoggerHook')
    ])
fp16 = dict(loss_scale=512.)
# checkpoint_config = dict(interval=1)
find_unused_parameters = True

# load_from = None
# resume_from = None
