# PROPOSE

**PRO**babilistic **POSE** estimation

## Getting started
Install the package from source:
```shell
pip install .
```
### Loading a pretrained cGNF
We provide the pretrained model which you can load with the following code snippet.
```python
from propose.models.flows import CondGraphFlow

flow = CondGraphFlow.from_pretrained('ANONYMOUS/cgnf/cgnf_human36m:best')
```

#### HRNet Loading
You can also load a pretrained HRNet model.
```python
from propose.models.detectors import HRNet

hrnet = HRNet.from_pretrained('ANONYMOUS/cgnf/hrnet:v0')
```
This will load the HRNet model provided in the [repo](https://github.com/leoxiaobin/deep-high-resolution-net.pytorch).
The model loaded here is the `pose_hrnet_w32_256x256` trained on the MPII dataset.

### Requirements
#### Requirements for the package
The requirements for the package can be found in the [requirements.txt](/requirements.txt).

#### Docker
Alternatively, you can use [Docker](https://www.docker.com/) to run the package.
This project requires that you have the following installed:
- `docker`
- `docker-compose`

Ensure that you have the base image pulled from the Docker Hub.
You can get the base image by running the following command:
```
docker pull ANONYMOUS
```

### Running notebooks
1. Clone the repository.
2. Navigate to the project directory. 
3. Run```docker-compose build base```
4. Run```docker-compose run -d -p 10101:8888 notebook_server```
5. You can now open JupyterLab in your browser at [`http://localhost:10101`](http://localhost:10101).

#### Available Models
MODELS ANONYMIZED FOR SUBMISSION

### Run Tests
To run the tests, from the root directory call:
```
docker-compose run pytest tests
```
 
*Note: This will create a separate image from the base service.*

