from abc import ABC, abstractmethod
import pandas as pd
import cvxpy as cp

class AbstractOptimizer(ABC):
    @abstractmethod
    def create_optimization_problem() -> cp.Problem:
        pass

    @abstractmethod
    def optimize() -> pd.DataFrame:
        pass

    @abstractmethod
    def round_optimal_solution(self, optimal_solution: pd.DataFrame) -> pd.DataFrame:
        pass

    @abstractmethod
    def get_optimal_solution() -> pd.DataFrame:
        pass