import numpy as np


def decode_matrix(Cenc, Van_inv, m, n):
    dim1_split, _ = Cenc[0].shape

    I = np.identity(dim1_split)
    Van_inv_kron = np.kron(Van_inv, I)

    Cenc = np.stack(Cenc)
    Cenc = Cenc.reshape(-1, Cenc.shape[-1])
    Cenc = Cenc[: dim1_split * m * n, :]

    C = np.matmul(Van_inv_kron, Cenc)

    C = np.vsplit(C, m * n)
    C = [np.vstack(C[i * m : (i + 1) * m]) for i in range(n)]
    C = np.hstack(C)

    return C
