import numpy as np

import utils


def get_van_inv(codebook, gets, m, n):
    Van = np.zeros([m * n, m * n])

    for i in range(m * n):
        ids = gets[i][-1]
        code = codebook[ids[0], ids[1]]
        fx = code
        gx = utils.cheby_poly(code, order=m)

        for j in range(n):
            for k in range(m):
                Van[i, m * j + k] = (fx**k) * (gx**j)

    Van_inv = np.linalg.inv(Van)

    return Van_inv
