% Computation %
%
clear all;
close all;

Seeds = [27111989, 27111989, 22131919, 16861113, 11131919];

sn = size(Seeds,2);
Nrounds=2001;
n=1000;
nc=100;

regret   = zeros(sn,Nrounds,1);
gkavgmin = zeros(sn,Nrounds,1);

s_xk = zeros(sn,Nrounds,n);
s_yk = zeros(sn,Nrounds,n);

b = 1.3*ones(nc,1);

localTimes = zeros(sn,Nrounds);
fractionViolatedConstraints = zeros(sn,Nrounds);

for i=1:sn
    try
        rng(Seeds(i));

        A =randn(n);
        Cx=rand(nc,n);
        Cy=rand(nc,n);
        
        [xk,yk,fk,gk,gkeq,fkacc,gkacc,gkeqacc,fkopt,locTimes,fracVioConstr] = runGame(A,Cx,Cy,b,Nrounds);
        localTimes(i,:) = locTimes;
        fractionViolatedConstraints(i,:) = fracVioConstr;
        
        regret(i,:) = fkacc-fkopt;
        gkavgmin(i,:) = abs(min(gkacc./([1:Nrounds]'*ones(1,nc+n)),[],2));
        s_xk(i,:,:) = xk;
        s_yk(i,:,:) = yk;
    catch me
        i=i-1;
    end
end

s_xkavg_norm = zeros(sn,Nrounds,1);
s_ykavg_norm = zeros(sn,Nrounds,1);

for i = 1:sn
    xkavg=zeros(Nrounds,n);
    ykavg=zeros(Nrounds,n);
    
    for t=1:Nrounds
        xkavg(t,:)=mean(s_xk(i,1:t,:),2);
        ykavg(t,:)=mean(s_yk(i,1:t,:),2);
    end

    xkavgend=xkavg(end,:)';
    ykavgend=ykavg(end,:)';

    diff_xkavg_xklast = xkavg-ones(Nrounds,1)*xkavgend';
    diff_ykavg_yklast = ykavg-ones(Nrounds,1)*ykavgend';

    s_xkavg_norm(i,:,:) = sqrt(sum(diff_xkavg_xklast.^2,2));
    s_ykavg_norm(i,:,:) = sqrt(sum(diff_ykavg_yklast.^2,2));
end


figure
plot(mean(fractionViolatedConstraints,1))
xlabel('rounds')
ylabel('Fraction of Violated Constraints')
saveas(gcf,'FractionOfViolatedConstraints.fig')

figure
plot(mean(localTimes,1))
xlabel('rounds')
ylabel('Velocity Projection Time (s)')
saveas(gcf,'VelocityProjectionTime.fig')

% Save all variables locally
filename = 'test.mat';
save(filename)



% Plotting %
%
% Clear the context and reload all variables ()
clear
filename = 'test.mat';
load(filename)

T = Nrounds+1;
x = [1:10:T-1];


% Regret
%
min_regret = min(regret, [], 1);
max_regret = max(regret, [], 1);
mean_regret = (1/sn) .* sum(regret, 1);

figure
plot(x, mean_regret(x), 'LineWidth', 1)
hold on
plot(x, 5.*sqrt(x),'--')
plot(x, min_regret(x), 'b', 'LineWidth', 0.1)
plot(x, max_regret(x), 'b', 'LineWidth', 0.1)
hold off
xlim([1 T])
xlabel('rounds')
ylabel('regret')
legend('regret','5*sqrt(x)', 'Location','NorthWest');
saveas(gcf,'regret.fig')


% Max Violation
%
min_regret = min(gkavgmin, [], 1);
max_regret = max(gkavgmin, [], 1);
mean_regret = (1/sn) .* sum(gkavgmin, 1);

figure
loglog(x,mean_regret(x), 'LineWidth', 1)
hold on
loglog(x,0.2./sqrt(x),'--')
loglog(x,min_regret(x), 'b', 'LineWidth', 0.1)
loglog(x,max_regret(x), 'b', 'LineWidth', 0.1)
hold off
xlabel('nrounds')
ylabel('|min avg violation|')
legend('|min avg violation|','0.2/sqrt(k)')
saveas(gcf,'maxviolation.fig')


% Convergence
%
min_x  = min(s_xkavg_norm, [], 1);
mean_x = (1/sn) .* sum(s_xkavg_norm, 1);
max_x  = max(s_xkavg_norm, [], 1);
min_y  = min(s_ykavg_norm, [], 1);
mean_y = (1/sn) .* sum(s_ykavg_norm, 1);
max_y  = max(s_ykavg_norm, [], 1);

figure
loglog(x,mean_x(x), 'LineWidth', 1)
hold all
loglog(x,mean_y(x), 'LineWidth', 1)
loglog(x,2./sqrt(x),'--')
loglog(x,min_x(x), 'b', 'LineWidth', 0.1)
loglog(x,max_x(x), 'b', 'LineWidth', 0.1)
loglog(x,min_y(x), 'r', 'LineWidth', 0.1)
loglog(x,max_y(x), 'r', 'LineWidth', 0.1)
xlabel('nrounds')
ylabel('two-norm of error')
legend('|xk_{avg}-xk_*|','|yk_{avg}-yk_*|','2/sqrt(k)')
saveas(gcf,'convergence_xkyk_avg.fig')
