function [xk,yk,fk,gk,gkeq,fkacc,gkacc,gkeqacc,fkopt]=runGame(A,Cx,Cy,b,Nrounds)

n=size(A,1);
nc=size(Cx,1);

x0=rand(n,1);
x0=x0/sum(x0);
xk=zeros(Nrounds,n);
yk=zeros(Nrounds,n);
fk=zeros(Nrounds,1);
gk=zeros(Nrounds,nc+n);
gkeq=zeros(Nrounds,1);

fkopt=zeros(Nrounds,1);

fkacc=zeros(Nrounds,1);
gkacc=zeros(Nrounds,nc+n);
gkeqacc=zeros(Nrounds,1);

x=x0;

for k=1:Nrounds

    alpha=100;
    sk=1/(alpha * sqrt(k));

    xk(k,:)=x;
    y=ComputeY(x,A);

    yk(k,:)=y;
    fk(k)=x'*A*y;
    if k>1
        fkacc(k)=fkacc(k-1)+fk(k);
    else
        fkacc(k)=fk(k);
    end
    
    yk_mean=mean(yk(1:k,:),1);
    [fkopt(k),xkopt]=ComputeFOpt(yk_mean,A,Cx,Cy,b);
    fkopt(k)=fkopt(k)*k;

    nabla_fk=A*y;
    
    Wtot=[-Cx; eye(n)];
    wtot=[b-Cy*yk_mean'; zeros(n,1)];
    Weq=ones(1,n);
    weq=1;

    g=Wtot*x+wtot;
    geq=Weq*x-weq;

    gk(k,:)=g;
    gkeq(k,:)=geq;

    if k>1
        gkup=gk(k,:);
        gkacc(k,:)=gkacc(k-1,:)+gkup;
        gkeqacc(k,:)=gkeqacc(k-1,:)+gkeq(k,:);
    else
        gkup=gk(k,:);
        gkacc(k,:)=gkup;
        gkeqacc(k,:)=gkeq(k,:);
    end

    idx=g<=1e-8;
    v=quadprog(eye(n),nabla_fk,-Wtot(idx,:),alpha*g(idx),Weq,-alpha*geq);
    
    x=x+sk*v;
end
end


function y=ComputeY(xk,A)

n=size(A,1);

ftmp=-A'*xk;
btmp=[zeros(n,1)];
Atmp=[-eye(n)];
Aeq=ones(1,n);
beq=1;

y1=linprog(ftmp,Atmp,btmp,Aeq,beq);

y2=rand(n,1);
y2=y2/sum(y2);

y=0.8*y1+0.2*y2;

end

function [fopt,xopt]=ComputeFOpt(ymean,A,Cx,Cy,b)
n=size(A,1);

ftmp=A*ymean';
Atmp=[Cx;-eye(n)];
btmp=[b-Cy*ymean';zeros(n,1)];
Aeq=ones(1,n);
beq=1;

[xopt,fopt]=linprog(ftmp,Atmp,btmp,Aeq,beq);
end
