# Reyes et al. (2025) — Trusting AI: Does Uncertainty Visualization Affect Decision-Making?

Citation Key: reyes2025uncertainty

## 1. Core Contribution
Evaluates impact of multiple uncertainty visualization strategies on user trust calibration and decision change behavior in AI-assisted tasks.

## 2. Study Design & Methods (From Retrieved Text)
- Comparative visualization formats (e.g., size, density, interval) with participant attitudes measured.
- Measures: decision change rate, trust differentials, attitude moderation effects.

## 3. Key Findings
- Size-based visualization yielded highest decision change rate among skeptical users.
- Uncertainty display improved trust selectively for participants initially distrustful of AI.
- Gaming experience predicted higher adaptability to uncertainty encodings.

## 4. Limitations
- Domain/task specificity (need to confirm exact task domain).
- Potential novelty effect of visualization styles.

## 5. Relevance to Mutual Wanting
- Supports tailoring uncertainty granularity to user segment (skeptical vs over-trusting) during model updates.

## 6. Metrics / Design Impact
- Informs adaptive Structured Uncertainty Ratio target thresholds.

## 7. Integration Plan
Related Work (uncertainty) + Metrics calibration strategy section.

## 8. Open Questions
- How to infer user trust stance passively in text-only Reddit discourse for adaptive messaging simulation?
