# Supplementary Materials

**Survival of the Useful: Evolutionary Boids as a Sandbox for Agent Societies**

This repository provides the supplementary materials accompanying the paper *Survival of the Useful: Evolutionary Boids as a Sandbox for Agent Societies*.

It includes reproducibility documentation, the open-sourced infrastructure, experiment data, and example commands to regenerate results.

***

## 📌 Reproducibility Statement

All experiments reported in the paper can be fully reproduced using the code and data provided here.

We release:

The exact source code used for simulation and evaluation.

Raw experimental outputs that form the basis of the ablation studies in the paper appendix.

Shell commands and configuration files to regenerate these outputs.

This ensures that every figure and table in the appendix can be reproduced end-to-end.

***

## 📂 Repository Structure

`/code/`\* – The open-sourced codebase for running the Boids simulation and evolutionary modules.

`/raw experiment data/`\* – Raw experiment outputs (corresponding to Appendix ablations).

`commands.md`\* – Commands and helper scripts for running experiments and reproducing results.

`README.md`\* – This document.

***

## ⚙️ Running the Experiments

To reproduce the data, use the commands in `commands.md`

***

## 📊 Raw Data

The `/raw experiment data/` directory contains the original experimental outputs used to generate figures and ablation tables.

Each subfolder corresponds to a different ablation setting, labeled consistently with the appendix