####### Parameter ################
seed<-1
repeat_num<-100
iteration_num<-500

threshold_theta<- 14800
kernel_var<-30000^2
kernel_length<-40
noise_var<-10^(-6)

fixed_straddle_beta<-3
theoretical_straddle_delta<-0.05
MILE_beta<-3
AF_num<- 7			#1: random, 2: US, , 4: Straddle, 5: LSE, 6: Proposed
##################################

####### True function ############
True_function_def<- function(x)
{
x1<-x[1]
x2<-x[2]
x3<-x[3]
x4<-x[4]
x5<-x[5]

-(( 100*(x2-x1^2)^2+(1-x1)^2 ) + ( 100*(x3-x2^2)^2+(1-x2)^2 ) + ( 100*(x4-x3^2)^2+(1-x3)^2 ) + ( 100*(x5-x4^2)^2+(1-x4)^2 ) )+53458.91
}
##################################




####### Function ############
compute_kernel<-function(x1,x2)
{
kernel_var*exp(-sum((x1-x2)^2)/kernel_length)
}

compute_kernel2<-function(x)
{
n1<- length(x)/2
n2<- length(x)
kernel_var*exp(-sum((x[1:n1]-x[(n1+1):n2])^2)/kernel_length)
}


compute_pre<-function(true,est)
{
	if(length(est)==0)
	{
		if(length(true)==0)
		{
		a<-1
		} else {
		a<-0
		}
	} else {
	a<- length(intersect(true,est))/length(est)
	}
a
}

compute_rec<-function(true,est)
{
	if(length(true)==0)
	{
	a<-1	
	} else {
	a<- length(intersect(true,est))/length(true)
	}
a
}

compute_Fscore<-function(pre,rec)
{
	if((pre+rec)==0)
	{
	a<-0	
	} else {
	a<- 2*pre*rec/(pre+rec)
	}
a
}

compute_acc<-function(true_H,true_L,est_H,est_L)
{
	(length(intersect(true_H,est_H)) + length(intersect(true_L,est_L)))/(length(true_H) + length(true_L))
}

##################################

####### Prior cov ################
#prior_cov<- diag(length(ALL_X[,1]))
#for(i in 1:length(ALL_X[,1]))
#{
#	for(j in 1:length(ALL_X[,1]))
#	{
#	prior_cov[i,j]<- compute_kernel(ALL_X[i,],ALL_X[j,])
#	}
#}
##################################

####### result mat ###############
result_mat_pre<- matrix(numeric(repeat_num*iteration_num),repeat_num,iteration_num)
result_mat_rec<- matrix(numeric(repeat_num*iteration_num),repeat_num,iteration_num)
result_mat_F<- matrix(numeric(repeat_num*iteration_num),repeat_num,iteration_num)
result_mat_acc<- matrix(numeric(repeat_num*iteration_num),repeat_num,iteration_num)
result_mat_loss<- matrix(numeric(repeat_num*iteration_num),repeat_num,iteration_num)
result_mat_meanloss<- matrix(numeric(repeat_num*iteration_num),repeat_num,iteration_num)
##################################


##################################
##################################
##################################
########### OPTIMIZE #############
##################################
##################################
##################################
for(w in 1:repeat_num)
{
set.seed((seed-1)*repeat_num+w)
calculated_X<- matrix(runif(500000,-5,5),100000,5)
calculated_f<- apply(calculated_X,1,True_function_def)
calculated_loss<-abs(calculated_f-threshold_theta)
calculated_H<- (calculated_f>=threshold_theta)*1
trueH<- c(1:100000)[calculated_H==1]
trueL<- c(1:100000)[calculated_H==0]

k_vec_mat<- numeric(100000)%x%t(numeric(iteration_num))

X<-c()
Y<-c()

new_x<- runif(5,-5,5)
new_y<- True_function_def(new_x) + rnorm(1,0,sqrt(noise_var))



	for(ww in 1:iteration_num)
	{
	X<-rbind(X,new_x)
	Y<-c(Y,new_y)
	
	k_vec_mat[,ww]<-  apply(cbind(calculated_X,t(new_x)%x%rep(1,100000)),1,compute_kernel2)
	K<-matrix(apply(cbind(X%x%rep(1,ww),rep(1,ww)%x%X),1,compute_kernel2),ww,ww)

	C<- K+ noise_var*diag(ww)
	Cinv<- solve(C)

	post_mean<- as.vector(cbind(k_vec_mat[,1:ww])%*%Cinv%*%Y) 
	post_var<- abs(kernel_var-rowSums((cbind(k_vec_mat[,1:ww])%*%Cinv)*cbind(k_vec_mat[,1:ww])))

	estH<- c(1:100000)[post_mean>=threshold_theta]
	estL<-  setdiff(c(1:100000),estH)

	result_mat_pre[w,ww]<-compute_pre(trueH,estH)
	result_mat_rec[w,ww]<-compute_rec(trueH,estH)
	result_mat_F[w,ww]<-compute_Fscore(result_mat_pre[w,ww],result_mat_rec[w,ww])
	result_mat_acc[w,ww]<-compute_acc(trueH,trueL,estH,estL)
	
	no_H_num<- intersect(trueH,estL)
	no_L_num<- intersect(trueL,estH)
		if(  length(c(no_H_num,no_L_num) )==0  )
		{
		result_mat_loss[w,ww]<-0
		result_mat_meanloss[w,ww]<-0
		} else {
		result_mat_loss[w,ww]<-max(((calculated_H+(post_mean>=threshold_theta)*1)==1)*calculated_loss)
		result_mat_meanloss[w,ww]<-sum(((calculated_H+(post_mean>=threshold_theta)*1)==1)*calculated_loss)/100000

		}
	########################## acquisition function ###################################
		if(AF_num==1)
		{
		new_x<- runif(5,-5,5)
		}

		if(AF_num==2)
		{
			def_post_var<- function(x)
			{
				k<-apply(cbind(t(x)%x%rep(1,ww),X),1,compute_kernel2)
				kernel_var-as.vector(t(k)%*%Cinv%*%k)
			}
			new_x1<- calculated_X[order(post_var,decreasing=T)[1],]
			new_x2<-optim(new_x1,def_post_var, method = c("L-BFGS-B"),lower=c(-5,-5,-5,-5,-5),upper=c(5,5,5,5,5),   control = list(fnscale = -1) )
			new_x2<-new_x2$par
			new_x3<-optim(runif(5,-5,5),def_post_var, method = c("L-BFGS-B"),lower=c(-5,-5,-5,-5,-5),upper=c(5,5,5,5,5),   control = list(fnscale = -1) )
			new_x3<-new_x3$par
			maximum_AF_num<-order(c(def_post_var(new_x1),def_post_var(new_x2),def_post_var(new_x3)),decreasing=T)[1]
			if(maximum_AF_num==1)
			{
			new_x<-new_x1
			}
			if(maximum_AF_num==2)
			{
			new_x<-new_x2
			}
			if(maximum_AF_num==3)
			{
			new_x<-new_x3
			}


		}

		
		
		if(AF_num==4)
		{
		para_beta<-fixed_straddle_beta

			def_STR<- function(x)
			{
				k<-apply(cbind(t(x)%x%rep(1,ww),X),1,compute_kernel2)
				c<- Cinv%*%k
				pm<- as.vector(t(c)%*%Y)
				ps<- sqrt(abs(kernel_var-as.vector(t(k)%*%c)))
			para_beta*ps-abs(pm-threshold_theta)
			}
			STR<- para_beta*sqrt(post_var)-abs(post_mean-threshold_theta)
			new_x1<- calculated_X[order(STR,decreasing=T)[1],]
			new_x2<-optim(new_x1,def_STR, method = c("L-BFGS-B"),lower=c(-5,-5,-5,-5,-5),upper=c(5,5,5,5,5),   control = list(fnscale = -1) )
			new_x2<-new_x2$par
			new_x3<-optim(runif(5,-5,5),def_STR, method = c("L-BFGS-B"),lower=c(-5,-5,-5,-5,-5),upper=c(5,5,5,5,5),   control = list(fnscale = -1) )
			new_x3<-new_x3$par
			maximum_AF_num<-order(c(def_STR(new_x1),def_STR(new_x2),def_STR(new_x3)),decreasing=T)[1]
			if(maximum_AF_num==1)
			{
			new_x<-new_x1
			}
			if(maximum_AF_num==2)
			{
			new_x<-new_x2
			}
			if(maximum_AF_num==3)
			{
			new_x<-new_x3
			}
		}

		if(AF_num==5)
		{
		para_beta<-sqrt(2*log(10^(15)*pi^2*ww^2/(6*theoretical_straddle_delta)))

			def_STR<- function(x)
			{
				k<-apply(cbind(t(x)%x%rep(1,ww),X),1,compute_kernel2)
				c<- Cinv%*%k
				pm<- as.vector(t(c)%*%Y)
				ps<- sqrt(abs(kernel_var-as.vector(t(k)%*%c)))
			para_beta*ps-abs(pm-threshold_theta)
			}
			STR<- para_beta*sqrt(post_var)-abs(post_mean-threshold_theta)
			new_x1<- calculated_X[order(STR,decreasing=T)[1],]
			new_x2<-optim(new_x1,def_STR, method = c("L-BFGS-B"),lower=c(-5,-5,-5,-5,-5),upper=c(5,5,5,5,5),   control = list(fnscale = -1) )
			new_x2<-new_x2$par
			new_x3<-optim(runif(5,-5,5),def_STR, method = c("L-BFGS-B"),lower=c(-5,-5,-5,-5,-5),upper=c(5,5,5,5,5),   control = list(fnscale = -1) )
			new_x3<-new_x3$par
			maximum_AF_num<-order(c(def_STR(new_x1),def_STR(new_x2),def_STR(new_x3)),decreasing=T)[1]
			if(maximum_AF_num==1)
			{
			new_x<-new_x1
			}
			if(maximum_AF_num==2)
			{
			new_x<-new_x2
			}
			if(maximum_AF_num==3)
			{
			new_x<-new_x3
			}

		}

		

		if(AF_num==6)
		{
		para_beta<-sqrt(rexp(1,0.5))

			def_STR<- function(x)
			{
				k<-apply(cbind(t(x)%x%rep(1,ww),X),1,compute_kernel2)
				c<- Cinv%*%k
				pm<- as.vector(t(c)%*%Y)
				ps<- sqrt(abs(kernel_var-as.vector(t(k)%*%c)))
			para_beta*ps-abs(pm-threshold_theta)
			}
			STR<- para_beta*sqrt(post_var)-abs(post_mean-threshold_theta)
			new_x1<- calculated_X[order(STR,decreasing=T)[1],]
			new_x2<-optim(new_x1,def_STR, method = c("L-BFGS-B"),lower=c(-5,-5,-5,-5,-5),upper=c(5,5,5,5,5),   control = list(fnscale = -1) )
			new_x2<-new_x2$par
			new_x3<-optim(runif(5,-5,5),def_STR, method = c("L-BFGS-B"),lower=c(-5,-5,-5,-5,-5),upper=c(5,5,5,5,5),   control = list(fnscale = -1) )
			new_x3<-new_x3$par
			maximum_AF_num<-order(c(def_STR(new_x1),def_STR(new_x2),def_STR(new_x3)),decreasing=T)[1]
			if(maximum_AF_num==1)
			{
			new_x<-new_x1
			}
			if(maximum_AF_num==2)
			{
			new_x<-new_x2
			}
			if(maximum_AF_num==3)
			{
			new_x<-new_x3
			}

		}

		

	###################################################################################
	
	new_y<- True_function_def(new_x)+ rnorm(1,0,sqrt(noise_var))


	}

}



write.table(result_mat_pre,"result_mat_pre.txt")
write.table(result_mat_rec,"result_mat_rec.txt")
write.table(result_mat_F,"result_mat_F.txt")
write.table(result_mat_acc,"result_mat_acc.txt")
write.table(result_mat_loss,"result_mat_loss.txt")
write.table(result_mat_meanloss,"result_mat_meanloss.txt")


