#!/bin/sh

LOG_PATH="baseline_bgl_logs"
mkdir -p $LOG_PATH

# adult
for ub in 0.07 0.1 0.14 0.2 0.3 0.5
do
    START=0 END=9
    for seed in $(seq $START $END); do 
    echo python main.py --data adult \
                                    --ub $ub \
                                    --name "${LOG_PATH}/adult_bgl_ub_${ub}" \
                                    --seed $seed
    
    python main.py --data adult \
                                    --ub $ub \
                                    --name "${LOG_PATH}/adult_bgl_ub_${ub}" \
                                    --seed $seed
    done
done

# compas
for ub in 0.1 0.15 0.2 0.3 0.5
do
    START=0 END=9
    for seed in $(seq $START $END); do 
    echo python main.py --data compas \
                                    --ub $ub \
                                    --name "${LOG_PATH}/compas_bgl_ub_${ub}" \
                                    --seed $seed

    python main.py --data compas \
                                    --ub $ub \
                                    --name "${LOG_PATH}/compas_bgl_ub_${ub}" \
                                    --seed $seed
    done
done

# crime
for ub in 0.01 0.015 0.02 0.03 0.05
do
    START=0 END=9
    for seed in $(seq $START $END); do 
    echo python main.py --data crime \
                                    --ub $ub \
                                    --name "${LOG_PATH}/crime_bgl_ub_${ub}" \
                                    --seed $seed

    python main.py --data crime \
                                    --ub $ub \
                                    --name "${LOG_PATH}/crime_bgl_ub_${ub}" \
                                    --seed $seed
    done
done

# law
for ub in 0.01 0.02 0.025 0.03 0.05
do
    START=0 END=9
    for seed in $(seq $START $END); do 
    echo python main.py --data law \
                                    --ub $ub \
                                    --name "${LOG_PATH}/law_bgl_ub_${ub}" \
                                    --seed $seed

    python main.py --data law \
                                    --ub $ub \
                                    --name "${LOG_PATH}/law_bgl_ub_${ub}" \
                                    --seed $seed
    done
done


