#!/bin/sh

LOG_PATH="baseline_cod_logs"
mkdir -p $LOG_PATH

# law
for eps in 0.01 0.1 0.5 1.0
do
    
        START=0 END=9
        for seed in $(seq $START $END); do 
        echo python main.py --dataset law \
                                        --eps $eps \
                                        --rff \
                                        --nonlinears \
                                        --name "${LOG_PATH}/law_cod_eff_nonlinears_eps_${eps}" \
                                        --seed $seed
                                        
        python main.py --dataset law \
                                        --eps $eps \
                                        --rff \
                                        --nonlinears \
                                        --name "${LOG_PATH}/law_cod_eff_nonlinears_eps_${eps}" \
                                        --seed $seed
                                
            for gamma in 0.1 1.0 10 100
                do
                echo python main.py --dataset law \
                                                --eps $eps \
                                                --gamma $gamma \
                                                --kernel \
                                                --name "${LOG_PATH}/law_cod_eps_${eps}_kernel_gamma_${gamma}" \
                                                --seed $seed

                python main.py --dataset law \
                                                --eps $eps \
                                                --gamma $gamma \
                                                --kernel \
                                                --name "${LOG_PATH}/law_cod_eps_${eps}_kernel_gamma_${gamma}" \
                                                --seed $seed

                done
        done
done