#!/bin/sh

# create log path
LOG_PATH="adult_logs"
mkdir -p $LOG_PATH


# nodebias
START=0 END=9
for seed in $(seq $START $END); do 
    echo python main_adult.py --model mlp \
                           --name "${LOG_PATH}/adult_nodebias" \
                           --seed $seed
    python main_adult.py --model mlp \
                           --name "${LOG_PATH}/adult_nodebias" \
                           --seed $seed
done

# CENet
for mu in 1.0 10 50 100
do
    START=0 END=9
    for seed in $(seq $START $END); do 
    echo python main_adult.py --model CENet \
                            --mu $mu \
                            --name "${LOG_PATH}/adult_CENet_mu_${mu}" \
                            --seed $seed
    python main_adult.py --model CENet \
                            --mu $mu \
                            --name "${LOG_PATH}/adult_CENet_mu_${mu}" \
                            --seed $seed
    done
done

# Wasserstein net
for mu in 1.0 10 50 100 
do
    START=0 END=9
    for seed in $(seq $START $END); do 
    echo python main_adult.py --model wmlp \
                            --mu $mu \
                            --name "${LOG_PATH}/adult_wmlp_mu_${mu}" \
                            --seed $seed
    python main_adult.py --model wmlp \
                            --mu $mu \
                            --name "${LOG_PATH}/adult_wmlp_mu_${mu}" \
                            --seed $seed
    done
done