#!/bin/sh

# create log path
LOG_PATH="compas_logs"
mkdir -p $LOG_PATH


# nodebias
START=0 END=9
for seed in $(seq $START $END); do 
    echo python main_compas.py --model mlp \
                           --name "${LOG_PATH}/compas_nodebias" \
                           --seed $seed
    python main_compas.py --model mlp \
                           --name "${LOG_PATH}/compas_nodebias" \
                           --seed $seed
done

# CENet
for mu in 0.1 0.5 1.0 5
do
    START=0 END=9
    for seed in $(seq $START $END); do 
    echo python main_compas.py --model CENet \
                            --mu $mu \
                            --name "${LOG_PATH}/compas_CENet_mu_${mu}" \
                            --seed $seed
    python main_compas.py --model CENet \
                            --mu $mu \
                            --name "${LOG_PATH}/compas_CENet_mu_${mu}" \
                            --seed $seed
    done
done

# Wasserstein net
for mu in 0.1 0.5 1.0 5
do
    START=0 END=9
    for seed in $(seq $START $END); do 
    echo python main_compas.py --model wmlp \
                            --mu $mu \
                            --name "${LOG_PATH}/compas_wmlp_mu_${mu}" \
                            --seed $seed
    python main_compas.py --model wmlp \
                            --mu $mu \
                            --name "${LOG_PATH}/compas_wmlp_mu_${mu}" \
                            --seed $seed
    done
done