#!/bin/sh

LOG_PATH="baseline_cod_logs"
mkdir -p $LOG_PATH

# compas
for eps in 0.01 0.1 0.5 1.0
do
    
        START=$1 END=$2
        for seed in $(seq $START $END); do 
        echo python main.py --dataset compas \
                                        --eps $eps \
                                        --rff \
                                        --nonlinears \
                                        --name "${LOG_PATH}/compas_cod_eff_nonlinears_eps_${eps}" \
                                        --seed $seed
                                        
        python main.py --dataset compas \
                                        --eps $eps \
                                        --rff \
                                        --nonlinears \
                                        --name "${LOG_PATH}/compas_cod_eff_nonlinears_eps_${eps}" \
                                        --seed $seed
                                
            for gamma in 0.1 1.0 10 100
                do
                echo python main.py --dataset compas \
                                                --eps $eps \
                                                --gamma $gamma \
                                                --kernel \
                                                --name "${LOG_PATH}/compas_cod_eps_${eps}_kernel_gamma_${gamma}" \
                                                --seed $seed

                python main.py --dataset compas \
                                                --eps $eps \
                                                --gamma $gamma \
                                                --kernel \
                                                --name "${LOG_PATH}/compas_cod_eps_${eps}_kernel_gamma_${gamma}" \
                                                --seed $seed

                done
        done
done