#!/bin/sh

# create log path
LOG_PATH="law_logs"
mkdir -p $LOG_PATH

# nodebias
START=0 END=9
for seed in $(seq $START $END); do 
    echo python main_law.py --model mlp \
                           --name "${LOG_PATH}/law_nodebias" \
                           --seed $seed
    python main_law.py --model mlp \
                           --name "${LOG_PATH}/law_nodebias" \
                           --seed $seed
done

# CENet
for mu in 0.1 1.0 5 10
do
    START=0 END=9
    for seed in $(seq $START $END); do 
    echo python main_law.py --model CENet \
                            --mu $mu \
                            --name "${LOG_PATH}/law_CENet_mu_${mu}" \
                            --seed $seed
    python main_law.py --model CENet \
                            --mu $mu \
                            --name "${LOG_PATH}/law_CENet_mu_${mu}" \
                            --seed $seed
    done
done

# Wasserstein net
for mu in 0.1 1.0 5 10
do
    START=0 END=9
    for seed in $(seq $START $END); do 
    echo python main_law.py --model wmlp \
                            --mu $mu \
                            --name "${LOG_PATH}/law_wmlp_mu_${mu}" \
                            --seed $seed
    python main_law.py --model wmlp \
                            --mu $mu \
                            --name "${LOG_PATH}/law_wmlp_mu_${mu}" \
                            --seed $seed
    done
done