import numpy as np
import scipy
import math
from sklearn.cluster import KMeans
import copy
from tqdm import tqdm
import random
from sklearn.neighbors import KDTree
from scipy.spatial.distance import cdist
from scipy.spatial.distance import pdist
import pickle
import time

import matplotlib.pyplot as plt
from matplotlib import ticker
from matplotlib.ticker import FuncFormatter

from OneStep import OneStepSwap

#skin=229
#shuttle=148
#covertype=31

database=[229,148,31]
candidate_k=[5,10,20]
s={229:'skin', 148:'shuttle',31:'covertype'}

for data_id in database:
  for k in candidate_k:
    print('begin: %s, k=%d'% (s[data_id],k))
    # fetch dataset
    

    f=open('./%s/%s-k-%d-coreset.pkl'%(s[data_id],s[data_id],k),'rb')
    Coreset=(pickle.load(f))

    OneStepSimulation=OneStepSwap(k)
    OneStepSimulation.pre_process(Coreset.coreset_points,Coreset.coreset_weight) 

    OneStepSimulation.one_step_swap()

    total_time=copy.deepcopy(Coreset.time)

    for i in range(len(OneStepSimulation.time)):
      total_time[Coreset.index[i]]+=OneStepSimulation.time[i]

    f=open('./%s/%s-k-%d-one-step-time.pkl'%(s[data_id],s[data_id],k),'wb')
    pickle.dump(total_time,f)

    f=open('./%s/%s-k-%d-one-step-consistency.pkl'%(s[data_id],s[data_id],k),'wb')
    pickle.dump((Coreset.index,OneStepSimulation.consistency),f)


    f=open('./%s/%s-k-%d-one-step-cost.pkl'%(s[data_id],s[data_id],k),'wb')
    pickle.dump((Coreset.index,OneStepSimulation.cost),f)


    print('finish %s, k=%d'%(s[data_id],k))
